/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.portlet.WindowState;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.apache.pluto.container.PortletPreference;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.dao.IStylesheetDescriptorDao;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.portlet.dao.IPortletEntityDao;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityDescriptor;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.PersistentPortletEntityWrapper;
import org.jasig.portal.portlet.registry.PortletEntityCache;
import org.jasig.portal.portlet.registry.PortletEntityData;
import org.jasig.portal.portlet.registry.PortletEntityIdImpl;
import org.jasig.portal.portlet.registry.SessionPortletEntityImpl;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.ConcurrentMapUtils;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;
import org.springframework.stereotype.Service;
import org.springframework.web.util.WebUtils;

@Service
public class PortletEntityRegistryImpl
implements IPortletEntityRegistry {
    static final char ID_PART_SEPERATOR = '_';
    static final Pattern ID_PART_SEPERATOR_PATTERN = Pattern.compile(Pattern.quote(String.valueOf('_')));
    static final char DELEGATE_LAYOUT_NODE_ID_SEPERATOR = '-';
    static final String DELEGATE_LAYOUT_NODE_ID_PREFIX = "dlg-";
    static final String PORTLET_ENTITY_DATA_ATTRIBUTE = PortletEntityRegistryImpl.class.getName() + ".PORTLET_ENTITY_DATA";
    static final String PORTLET_ENTITY_ATTRIBUTE = PortletEntityRegistryImpl.class.getName() + ".PORTLET_ENTITY.thread-";
    static final String PORTLET_ENTITY_LOCK_MAP_ATTRIBUTE = PortletEntityRegistryImpl.class.getName() + ".PORTLET_ENTITY_LOCK_MAP_ATTRIBUTE";
    static final String PORTLET_DEFINITION_LOOKUP_MAP_ATTRIBUTE = PortletEntityRegistryImpl.class.getName() + ".PORTLET_DEFINITION_LOOKUP_MAP_ATTRIBUTE";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IUserInstanceManager userInstanceManager;
    private IPortletEntityDao portletEntityDao;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;
    private IStylesheetDescriptorDao stylesheetDescriptorDao;
    private Ehcache entityIdParseCache;
    private static final IPortletDefinition NO_PERMISSION_PORTLET_DEFINITION = new /* Unavailable Anonymous Inner Class!! */;

    @Autowired
    public void setStylesheetDescriptorDao(IStylesheetDescriptorDao stylesheetDescriptorDao) {
        this.stylesheetDescriptorDao = stylesheetDescriptorDao;
    }

    @Autowired
    public void setEntityIdParseCache(@Qualifier(value="org.jasig.portal.portlet.dao.jpa.PortletEntityImpl.idParseCache") Ehcache entityIdParseCache) {
        this.entityIdParseCache = entityIdParseCache;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setPortletEntityDao(@Qualifier(value="transient") IPortletEntityDao portletEntityDao) {
        this.portletEntityDao = portletEntityDao;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public IPortletEntity getPortletEntity(HttpServletRequest request, IPortletEntityId portletEntityId) {
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        PortletEntityCache portletEntityCache = this.getPortletEntityMap(request);
        return this.getPortletEntity(request, portletEntityCache, portletEntityId, null, -1);
    }

    public IPortletEntity getPortletEntity(HttpServletRequest request, String portletEntityIdString) {
        IPortletEntityId portletEntityId = this.parseConsistentPortletEntityId(request, portletEntityIdString);
        return this.getPortletEntity(request, portletEntityId);
    }

    public IPortletEntity getOrCreateDefaultPortletEntity(HttpServletRequest request, IPortletDefinitionId portletDefinitionId) {
        String portletFName;
        Validate.notNull((Object)request, (String)"HttpServletRequest cannot be null");
        Validate.notNull((Object)portletDefinitionId, (String)"portletDefinitionId cannot be null");
        IPortletDefinition portletDefinition = this.getPortletDefinition(request, portletDefinitionId);
        if (portletDefinition == null) {
            throw new IllegalArgumentException("No portlet definition found for id '" + portletDefinitionId + "'.");
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        String layoutNodeId = userLayoutManager.getSubscribeId(portletFName = portletDefinition.getFName());
        if (layoutNodeId == null) {
            throw new IllegalArgumentException("No layout node ID found for fname '" + portletFName + "'.");
        }
        this.logger.trace("Found layout node {} for portlet definition {}", (Object)layoutNodeId, (Object)portletFName);
        IPerson person = userInstance.getPerson();
        int personId = person.getID();
        return this.getOrCreatePortletEntity(request, portletDefinitionId, layoutNodeId, personId);
    }

    public IPortletEntity getOrCreatePortletEntity(HttpServletRequest request, IUserInstance userInstance, String layoutNodeId) {
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        IUserLayoutChannelDescription channelNode = (IUserLayoutChannelDescription)userLayoutManager.getNode(layoutNodeId);
        if (channelNode == null) {
            this.logger.warn("No layout node exists for id " + layoutNodeId + ", no portlet entity will be returned.");
            return null;
        }
        String channelPublishId = channelNode.getChannelPublishId();
        IPortletDefinition portletDefinition = this.getPortletDefinition(request, userInstance, channelPublishId);
        if (portletDefinition != null) {
            IPerson person = userInstance.getPerson();
            return this.getOrCreatePortletEntity(request, portletDefinition.getPortletDefinitionId(), layoutNodeId, person.getID());
        }
        return null;
    }

    public IPortletEntity getOrCreatePortletEntity(HttpServletRequest request, IPortletDefinitionId portletDefinitionId, String layoutNodeId, int userId) {
        PortletEntityCache portletEntityCache = this.getPortletEntityMap(request);
        IPortletEntity portletEntity = this.getPortletEntity(request, portletEntityCache, null, layoutNodeId, userId);
        if (portletEntity != null) {
            IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
            if (portletDefinitionId.equals(portletDefinition.getPortletDefinitionId())) {
                return portletEntity;
            }
            this.logger.warn("Found portlet entity '{}' is not the correct entity for portlet definition id: {}. The entity will be deleted and a new one created.", (Object)portletEntity, (Object)portletDefinitionId);
            this.deletePortletEntity(request, portletEntity, false);
        }
        PortletEntityCache portletEntityDataMap = this.getPortletEntityDataMap(request);
        IPortletEntityId portletEntityId = this.createConsistentPortletEntityId(portletDefinitionId, layoutNodeId, userId);
        PortletEntityData portletEntityData = new PortletEntityData(portletEntityId, portletDefinitionId, layoutNodeId, userId);
        portletEntityData = (PortletEntityData)portletEntityDataMap.storeIfAbsentEntity((IPortletEntityDescriptor)portletEntityData);
        portletEntity = this.wrapPortletEntityData(portletEntityData);
        portletEntity = (IPortletEntity)portletEntityCache.storeIfAbsentEntity((IPortletEntityDescriptor)portletEntity);
        return portletEntity;
    }

    public IPortletEntity getOrCreatePortletEntityByFname(HttpServletRequest request, IUserInstance userInstance, String fname) {
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        String subscribeId = userLayoutManager.getSubscribeId(fname);
        return this.getOrCreatePortletEntity(request, userInstance, subscribeId);
    }

    public IPortletEntity getOrCreatePortletEntityByFname(HttpServletRequest request, IUserInstance userInstance, String fname, String preferredChannelSubscribeId) {
        try {
            IPortletDefinition portletDefinition;
            IPortletEntity portletEntity = this.getOrCreatePortletEntity(request, userInstance, preferredChannelSubscribeId);
            if (portletEntity != null && fname.equals((portletDefinition = portletEntity.getPortletDefinition()).getFName())) {
                return portletEntity;
            }
        }
        catch (PortalException pe) {
            // empty catch block
        }
        return this.getOrCreatePortletEntityByFname(request, userInstance, fname);
    }

    public IPortletEntity getOrCreateDelegatePortletEntity(HttpServletRequest request, IPortletWindowId parentPortletWindowId, IPortletDefinitionId delegatePortletDefinitionId) {
        String layoutNodeId = DELEGATE_LAYOUT_NODE_ID_PREFIX + parentPortletWindowId.getStringId().replace('_', '-');
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IPerson person = userInstance.getPerson();
        int userId = person.getID();
        return this.getOrCreatePortletEntity(request, delegatePortletDefinitionId, layoutNodeId, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePortletEntity(HttpServletRequest request, IPortletEntity portletEntity) {
        block14: {
            Validate.notNull((Object)portletEntity, (String)"portletEntity can not be null");
            IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
            IPerson person = userInstance.getPerson();
            if (person.isGuest()) {
                return;
            }
            IPortletEntityId wrapperPortletEntityId = portletEntity.getPortletEntityId();
            Lock portletEntityLock = this.getPortletEntityLock(request, wrapperPortletEntityId);
            portletEntityLock.lock();
            try {
                boolean shouldBePersisted = this.shouldBePersisted(portletEntity);
                if (portletEntity instanceof PersistentPortletEntityWrapper) {
                    IPortletEntity persistentEntity = ((PersistentPortletEntityWrapper)portletEntity).getPersistentEntity();
                    if (shouldBePersisted) {
                        try {
                            this.portletEntityDao.updatePortletEntity(persistentEntity);
                            break block14;
                        }
                        catch (HibernateOptimisticLockingFailureException e) {
                            boolean exists = this.portletEntityDao.portletEntityExists(persistentEntity.getPortletEntityId());
                            if (!exists) {
                                this.logger.warn("The persistent portlet has already been deleted: " + persistentEntity + ". The passed entity should be persistent so a new persistent entity will be created");
                                this.deletePortletEntity(request, portletEntity, true);
                                this.createPersistentEntity(persistentEntity, wrapperPortletEntityId);
                                break block14;
                            }
                            throw e;
                        }
                    }
                    IPortletDefinitionId portletDefinitionId = portletEntity.getPortletDefinitionId();
                    String layoutNodeId = portletEntity.getLayoutNodeId();
                    int userId = portletEntity.getUserId();
                    this.deletePortletEntity(request, portletEntity, false);
                    this.getOrCreatePortletEntity(request, portletDefinitionId, layoutNodeId, userId);
                    break block14;
                }
                if (portletEntity instanceof SessionPortletEntityImpl) {
                    if (shouldBePersisted) {
                        this.deletePortletEntity(request, portletEntity, false);
                        IPortletEntity persistentEntity = this.createPersistentEntity(portletEntity, wrapperPortletEntityId);
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Session scoped entity " + wrapperPortletEntityId + " should now be persistent. Deleted it from session cache and created persistent portlet entity " + persistentEntity.getPortletEntityId());
                        }
                    } else {
                        int userId;
                        String channelSubscribeId = portletEntity.getLayoutNodeId();
                        IPortletEntity existingPersistentEntity = this.portletEntityDao.getPortletEntity(channelSubscribeId, userId = portletEntity.getUserId());
                        if (existingPersistentEntity != null) {
                            IPortletEntityId consistentPortletEntityId = this.createConsistentPortletEntityId(existingPersistentEntity);
                            existingPersistentEntity = new PersistentPortletEntityWrapper(existingPersistentEntity, consistentPortletEntityId);
                            this.logger.warn("A persistent portlet entity already exists: " + existingPersistentEntity + ". The passed entity has no preferences so the persistent version will be deleted");
                            this.deletePortletEntity(request, existingPersistentEntity, false);
                            PortletEntityCache portletEntityMap = this.getPortletEntityMap(request);
                            portletEntityMap.storeIfAbsentEntity((IPortletEntityDescriptor)portletEntity);
                            PortletEntityCache portletEntityDataMap = this.getPortletEntityDataMap(request);
                            portletEntityDataMap.storeIfAbsentEntity((IPortletEntityDescriptor)((SessionPortletEntityImpl)portletEntity).getPortletEntityData());
                        }
                    }
                    break block14;
                }
                throw new IllegalArgumentException("Invalid portlet entity implementation passed: " + portletEntity.getClass());
            }
            finally {
                portletEntityLock.unlock();
            }
        }
    }

    public Lock getPortletEntityLock(HttpServletRequest request, IPortletEntityId portletEntityId) {
        ConcurrentMap lockMap = this.getPortletEntityLockMap(request);
        Lock lock = (Lock)lockMap.get(portletEntityId);
        if (lock != null) {
            return lock;
        }
        lock = this.createPortletEntityLock();
        return (Lock)ConcurrentMapUtils.putIfAbsent((ConcurrentMap)lockMap, (Object)portletEntityId, (Object)lock);
    }

    protected IPortletDefinition getPortletDefinition(HttpServletRequest request, String portletDefinitionIdStr) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        return this.getPortletDefinition(request, userInstance, portletDefinitionIdStr);
    }

    protected IPortletDefinition getPortletDefinition(HttpServletRequest request, IPortletDefinitionId portletDefinitionId) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        return this.getPortletDefinition(userInstance, portletDefinitionId);
    }

    protected IPortletDefinition getPortletDefinition(HttpServletRequest request, IUserInstance userInstance, String portletDefinitionIdStr) {
        ConcurrentMap portletDefinitions = PortalWebUtils.getMapRequestAttribute((ServletRequest)(request = this.portalRequestUtils.getOriginalPortalRequest(request)), (String)PORTLET_DEFINITION_LOOKUP_MAP_ATTRIBUTE);
        IPortletDefinition portletDefinition = (IPortletDefinition)portletDefinitions.get(portletDefinitionIdStr);
        if (portletDefinition == NO_PERMISSION_PORTLET_DEFINITION) {
            return null;
        }
        if (portletDefinition != null) {
            return portletDefinition;
        }
        portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionIdStr);
        if ((portletDefinition = this.checkPortletDefinitionRenderPermissions(userInstance, portletDefinition)) == null) {
            portletDefinitions.put(portletDefinitionIdStr, NO_PERMISSION_PORTLET_DEFINITION);
        } else {
            portletDefinitions.put(portletDefinitionIdStr, portletDefinition);
        }
        return portletDefinition;
    }

    protected IPortletDefinition getPortletDefinition(IUserInstance userInstance, IPortletDefinitionId portletDefinitionId) {
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
        return this.checkPortletDefinitionRenderPermissions(userInstance, portletDefinition);
    }

    private IPortletDefinition checkPortletDefinitionRenderPermissions(IUserInstance userInstance, IPortletDefinition portletDefinition) {
        if (portletDefinition == null) {
            return null;
        }
        IPerson person = userInstance.getPerson();
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        if (ap.canRender(portletDefinition.getPortletDefinitionId().getStringId())) {
            return portletDefinition;
        }
        return null;
    }

    protected IPortletEntity createPersistentEntity(IPortletEntity portletEntity, IPortletEntityId wrapperPortletEntityId) {
        int userId;
        IPortletDefinitionId portletDefinitionId = portletEntity.getPortletDefinitionId();
        String layoutNodeId = portletEntity.getLayoutNodeId();
        IPortletEntity persistentEntity = this.portletEntityDao.getPortletEntity(layoutNodeId, userId = portletEntity.getUserId());
        if (persistentEntity != null) {
            this.logger.warn("A persistent portlet entity already exists: " + persistentEntity + ". The data from the passed in entity will be copied to the persistent entity: " + portletEntity);
        } else {
            persistentEntity = this.portletEntityDao.createPortletEntity(portletDefinitionId, layoutNodeId, userId);
        }
        List existingPreferences = portletEntity.getPortletPreferences();
        List persistentPreferences = persistentEntity.getPortletPreferences();
        if (persistentPreferences != existingPreferences) {
            persistentPreferences.clear();
            for (IPortletPreference preference : existingPreferences) {
                persistentPreferences.add(new PortletPreferenceImpl((PortletPreference)preference));
            }
        }
        Map windowStates = portletEntity.getWindowStates();
        for (Map.Entry windowStateEntry : windowStates.entrySet()) {
            Long stylesheetDescriptorId = (Long)windowStateEntry.getKey();
            IStylesheetDescriptor stylesheetDescriptor = this.stylesheetDescriptorDao.getStylesheetDescriptor(stylesheetDescriptorId.longValue());
            WindowState windowState = (WindowState)windowStateEntry.getValue();
            persistentEntity.setWindowState(stylesheetDescriptor, windowState);
        }
        this.portletEntityDao.updatePortletEntity(persistentEntity);
        return persistentEntity;
    }

    protected void deletePortletEntity(HttpServletRequest request, IPortletEntity portletEntity, boolean cacheOnly) {
        block3: {
            IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
            PortletEntityCache portletEntityMap = this.getPortletEntityMap(request);
            portletEntityMap.removeEntity(portletEntityId);
            PortletEntityCache portletEntityDataMap = this.getPortletEntityDataMap(request);
            portletEntityDataMap.removeEntity(portletEntityId);
            if (!cacheOnly && portletEntity instanceof PersistentPortletEntityWrapper) {
                IPortletEntity persistentEntity = ((PersistentPortletEntityWrapper)portletEntity).getPersistentEntity();
                try {
                    this.portletEntityDao.deletePortletEntity(persistentEntity);
                }
                catch (HibernateOptimisticLockingFailureException e) {
                    this.logger.warn("This persistent portlet has already been deleted: " + persistentEntity + ", trying to find and delete by layout node and user.");
                    IPortletEntity existingPersistentEntity = this.portletEntityDao.getPortletEntity(persistentEntity.getLayoutNodeId(), persistentEntity.getUserId());
                    if (existingPersistentEntity == null) break block3;
                    this.portletEntityDao.deletePortletEntity(existingPersistentEntity);
                }
            }
        }
    }

    protected IPortletEntity getPortletEntity(HttpServletRequest request, PortletEntityCache<IPortletEntity> portletEntityCache, IPortletEntityId portletEntityId, String layoutNodeId, int userId) {
        PortletEntityIdImpl consistentPortletEntityId;
        IPortletEntity portletEntity = portletEntityId != null ? (IPortletEntity)portletEntityCache.getEntity(portletEntityId) : (IPortletEntity)portletEntityCache.getEntity(layoutNodeId, userId);
        if (portletEntity != null) {
            this.logger.trace("Found IPortletEntity {} in request cache", (Object)portletEntity.getPortletEntityId());
            return portletEntity;
        }
        PortletEntityCache portletEntityDataMap = this.getPortletEntityDataMap(request);
        PortletEntityData portletEntityData = portletEntityId != null ? (PortletEntityData)portletEntityDataMap.getEntity(portletEntityId) : (PortletEntityData)portletEntityDataMap.getEntity(layoutNodeId, userId);
        if (portletEntityData != null) {
            portletEntity = (IPortletEntity)portletEntityCache.storeIfAbsentEntity(portletEntityData.getPortletEntityId(), (Function)new /* Unavailable Anonymous Inner Class!! */);
            return portletEntity;
        }
        if (portletEntityId != null) {
            if (portletEntityId instanceof PortletEntityIdImpl) {
                consistentPortletEntityId = (PortletEntityIdImpl)portletEntityId;
                String localLayoutNodeId = consistentPortletEntityId.getLayoutNodeId();
                int localUserId = consistentPortletEntityId.getUserId();
                portletEntity = this.portletEntityDao.getPortletEntity(localLayoutNodeId, localUserId);
            } else {
                portletEntity = this.portletEntityDao.getPortletEntity(portletEntityId);
            }
        } else {
            portletEntity = this.portletEntityDao.getPortletEntity(layoutNodeId, userId);
        }
        if (portletEntity != null) {
            consistentPortletEntityId = this.createConsistentPortletEntityId(portletEntity);
            IPortletEntity anonPortletEntity = portletEntity;
            portletEntity = (IPortletEntity)portletEntityCache.storeIfAbsentEntity((IPortletEntityId)consistentPortletEntityId, (Function)new /* Unavailable Anonymous Inner Class!! */);
            return portletEntity;
        }
        return null;
    }

    protected IPortletEntityId createConsistentPortletEntityId(IPortletEntity portletEntity) {
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
        String layoutNodeId = portletEntity.getLayoutNodeId();
        int userId = portletEntity.getUserId();
        return this.createConsistentPortletEntityId(portletDefinitionId, layoutNodeId, userId);
    }

    protected IPortletEntityId createConsistentPortletEntityId(PortletEntityData portletEntityData) {
        IPortletDefinitionId portletDefinitionId = portletEntityData.getPortletDefinitionId();
        String layoutNodeId = portletEntityData.getLayoutNodeId();
        int userId = portletEntityData.getUserId();
        return this.createConsistentPortletEntityId(portletDefinitionId, layoutNodeId, userId);
    }

    protected IPortletEntityId createConsistentPortletEntityId(IPortletDefinitionId portletDefinitionId, String layoutNodeId, int userId) {
        String compositeId = portletDefinitionId.getStringId() + '_' + layoutNodeId + '_' + userId;
        return new PortletEntityIdImpl(portletDefinitionId, layoutNodeId, userId, compositeId);
    }

    protected IPortletEntityId parseConsistentPortletEntityId(HttpServletRequest request, String consistentEntityIdString) {
        int userId;
        Object value;
        Validate.notNull((Object)consistentEntityIdString, (String)"consistentEntityIdString can not be null");
        Element element = this.entityIdParseCache.get((Serializable)((Object)consistentEntityIdString));
        if (element != null && (value = element.getObjectValue()) != null) {
            return (IPortletEntityId)value;
        }
        String[] idParts = ID_PART_SEPERATOR_PATTERN.split(consistentEntityIdString);
        if (idParts.length != 3) {
            throw new IllegalArgumentException("consistentEntityIdString does not have 3 parts and is invalid: " + consistentEntityIdString);
        }
        String portletDefinitionIdString = idParts[0];
        IPortletDefinition portletDefinition = this.getPortletDefinition(request, portletDefinitionIdString);
        if (portletDefinition == null) {
            throw new IllegalArgumentException("No parent IPortletDefinition found for " + portletDefinitionIdString + " from entity id string: " + consistentEntityIdString);
        }
        IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        String layoutNodeId = idParts[1];
        if (!layoutNodeId.startsWith(DELEGATE_LAYOUT_NODE_ID_PREFIX)) {
            IUserLayoutNodeDescription node = userLayoutManager.getNode(layoutNodeId);
            if (node == null || node.getType() != IUserLayoutNodeDescription.LayoutNodeType.PORTLET) {
                throw new IllegalArgumentException("No portlet layout node found for " + layoutNodeId + " from entity id string: " + consistentEntityIdString);
            }
            IUserLayoutChannelDescription portletNode = (IUserLayoutChannelDescription)node;
            String channelPublishId = portletNode.getChannelPublishId();
            if (!portletDefinitionId.getStringId().equals(channelPublishId)) {
                throw new IllegalArgumentException("The portlet layout node found for " + layoutNodeId + " does not match the IPortletDefinitionId " + portletDefinitionId + " specified in entity id string: " + consistentEntityIdString);
            }
        }
        try {
            userId = Integer.parseInt(idParts[2]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The user id " + idParts[2] + " is not a valid integer from entity id string: " + consistentEntityIdString, e);
        }
        IPortletEntityId portletEntityId = this.createConsistentPortletEntityId(portletDefinitionId, layoutNodeId, userId);
        this.entityIdParseCache.put(new Element((Serializable)((Object)consistentEntityIdString), (Serializable)portletEntityId));
        return portletEntityId;
    }

    protected Lock createPortletEntityLock() {
        return new ReentrantLock(true);
    }

    protected ConcurrentMap<IPortletEntityId, Lock> getPortletEntityLockMap(HttpServletRequest request) {
        request = this.portalRequestUtils.getOriginalPortalRequest(request);
        HttpSession session = request.getSession();
        return PortalWebUtils.getMapSessionAttribute((HttpSession)session, (String)PORTLET_ENTITY_LOCK_MAP_ATTRIBUTE);
    }

    protected PortletEntityCache<IPortletEntity> getPortletEntityMap(HttpServletRequest request) {
        String entityMapAttribute;
        PortletEntityCache cache = (PortletEntityCache)(request = this.portalRequestUtils.getOriginalPortletOrPortalRequest(request)).getAttribute(entityMapAttribute = PORTLET_ENTITY_ATTRIBUTE + Thread.currentThread().getId());
        if (cache == null) {
            cache = new PortletEntityCache(false);
            request.setAttribute(PORTLET_ENTITY_ATTRIBUTE, (Object)cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletEntityCache<PortletEntityData> getPortletEntityDataMap(HttpServletRequest request) {
        Object mutex;
        request = this.portalRequestUtils.getOriginalPortalRequest(request);
        HttpSession session = request.getSession();
        Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            PortletEntityCache cache = (PortletEntityCache)session.getAttribute(PORTLET_ENTITY_DATA_ATTRIBUTE);
            if (cache == null) {
                cache = new PortletEntityCache();
                session.setAttribute(PORTLET_ENTITY_DATA_ATTRIBUTE, (Object)cache);
            }
            return cache;
        }
    }

    protected IPortletEntity wrapPortletEntityData(PortletEntityData portletEntityData) {
        IPortletDefinitionId portletDefinitionId = portletEntityData.getPortletDefinitionId();
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
        return new SessionPortletEntityImpl(portletDefinition, portletEntityData);
    }

    public boolean shouldBePersisted(IPortletEntity portletEntity) {
        String layoutNodeId = portletEntity.getLayoutNodeId();
        if (layoutNodeId.startsWith(DELEGATE_LAYOUT_NODE_ID_PREFIX)) {
            return false;
        }
        List preferences = portletEntity.getPortletPreferences();
        return CollectionUtils.isNotEmpty((Collection)preferences) || !portletEntity.getWindowStates().isEmpty();
    }
}

