/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.WindowState;
import org.apache.commons.lang.Validate;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityDescriptor;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.registry.PortletEntityData;

class SessionPortletEntityImpl
implements IPortletEntity,
IPortletEntityDescriptor {
    private final IPortletDefinition portletDefinition;
    private final PortletEntityData portletEntityData;
    private final Map<Long, WindowState> windowStates = new ConcurrentHashMap();
    private List<IPortletPreference> portletPreferences = new ArrayList(0);

    public SessionPortletEntityImpl(IPortletDefinition portletDefinition, PortletEntityData portletEntityData) {
        Validate.notNull((Object)portletDefinition, (String)"portletDefinition cannot be null");
        Validate.notNull((Object)portletEntityData, (String)"portletEntityData cannot be null");
        this.portletDefinition = portletDefinition;
        this.portletEntityData = portletEntityData;
    }

    public PortletEntityData getPortletEntityData() {
        return this.portletEntityData;
    }

    public IPortletDefinitionId getPortletDefinitionId() {
        return this.portletDefinition.getPortletDefinitionId();
    }

    public IPortletEntityId getPortletEntityId() {
        return this.portletEntityData.getPortletEntityId();
    }

    public IPortletDefinition getPortletDefinition() {
        return this.portletDefinition;
    }

    public String getLayoutNodeId() {
        return this.portletEntityData.getLayoutNodeId();
    }

    public int getUserId() {
        return this.portletEntityData.getUserId();
    }

    public Map<Long, WindowState> getWindowStates() {
        return Collections.unmodifiableMap(this.windowStates);
    }

    public WindowState getWindowState(IStylesheetDescriptor stylesheetDescriptor) {
        return (WindowState)this.windowStates.get(stylesheetDescriptor.getId());
    }

    public void setWindowState(IStylesheetDescriptor stylesheetDescriptor, WindowState state) {
        if (state == null) {
            this.windowStates.remove(stylesheetDescriptor.getId());
        } else {
            this.windowStates.put(stylesheetDescriptor.getId(), state);
        }
    }

    public List<IPortletPreference> getPortletPreferences() {
        return this.portletPreferences;
    }

    public boolean setPortletPreferences(List<IPortletPreference> portletPreferences) {
        if (portletPreferences == null) {
            boolean modified = !this.portletPreferences.isEmpty();
            this.portletPreferences.clear();
            return modified;
        }
        boolean modified = !this.portletPreferences.equals(portletPreferences);
        this.portletPreferences = portletPreferences;
        return modified;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portletEntityData.getLayoutNodeId() == null ? 0 : this.portletEntityData.getLayoutNodeId().hashCode());
        result = 31 * result + (this.portletDefinition == null ? 0 : this.portletDefinition.hashCode());
        result = 31 * result + this.portletEntityData.getUserId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!IPortletEntity.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        IPortletEntity other = (IPortletEntity)obj;
        if (this.portletEntityData.getLayoutNodeId() == null ? other.getLayoutNodeId() != null : !this.portletEntityData.getLayoutNodeId().equals(other.getLayoutNodeId())) {
            return false;
        }
        if (this.portletDefinition == null ? other.getPortletDefinition() != null : !this.portletDefinition.equals((Object)other.getPortletDefinition())) {
            return false;
        }
        return this.portletEntityData.getUserId() == other.getUserId();
    }

    public String toString() {
        return "PortletEntity [portletEntityId=" + this.portletEntityData.getPortletEntityId() + ", " + "layoutNodeId=" + this.portletEntityData.getLayoutNodeId() + ", " + "userId=" + this.portletEntityData.getUserId() + ", " + "portletDefinition=" + this.portletDefinition + "]";
    }
}

