/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.rendering.QueuedEvent;
import org.jasig.portal.utils.ConcurrentMapUtils;

public class PortletEventQueue
implements Iterable<IPortletWindowId> {
    private final Queue<QueuedEvent> rawEventQueue = new ConcurrentLinkedQueue();
    private final ConcurrentMap<IPortletWindowId, Queue<QueuedEvent>> resolvedEventQueues = new ConcurrentHashMap();

    PortletEventQueue() {
    }

    public void addEvents(Collection<? extends QueuedEvent> events) {
        this.rawEventQueue.addAll(events);
    }

    public Queue<QueuedEvent> getUnresolvedEvents() {
        return this.rawEventQueue;
    }

    public void offerEvent(IPortletWindowId portletWindowId, QueuedEvent event) {
        Queue events = (Queue)this.resolvedEventQueues.get(portletWindowId);
        if (events == null) {
            events = (Queue)ConcurrentMapUtils.putIfAbsent((ConcurrentMap)this.resolvedEventQueues, (Object)portletWindowId, new ConcurrentLinkedQueue());
        }
        events.offer(event);
    }

    public QueuedEvent pollEvent(IPortletWindowId portletWindowId) {
        Queue queue = (Queue)this.resolvedEventQueues.get(portletWindowId);
        return queue != null ? (QueuedEvent)queue.poll() : null;
    }

    @Override
    public Iterator<IPortletWindowId> iterator() {
        return this.resolvedEventQueues.keySet().iterator();
    }
}

