/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering.worker;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;
import org.jasig.portal.portlet.rendering.PortletRenderResult;
import org.jasig.portal.portlet.rendering.RenderPortletOutputHandler;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionContext;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionInterceptor;
import org.jasig.portal.portlet.rendering.worker.IPortletFailureExecutionWorker;
import org.jasig.portal.portlets.error.PortletErrorController;
import org.jasig.portal.utils.web.PortletHttpServletRequestWrapper;

final class PortletFailureExecutionWorker
implements IPortletFailureExecutionWorker {
    private static final int SIGNAL_THE_OPERATION_DOES_NOT_TIMEOUT = -1;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, Object> executionAttributes = new ConcurrentHashMap();
    private final IPortletRenderer portletRenderer;
    private final List<IPortletExecutionInterceptor> interceptors;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final IPortletWindowId errorPortletWindowId;
    private final IPortletWindowId failedPortletWindowId;
    private final String failedPortletFname;
    private final Exception cause;
    private PortletRenderResult portletRenderResult;
    private String output;
    private boolean retrieved = false;
    private long submitted = 0L;
    private long completed = 0L;

    public PortletFailureExecutionWorker(IPortletRenderer portletRenderer, List<IPortletExecutionInterceptor> interceptors, HttpServletRequest request, HttpServletResponse response, IPortletWindowId errorPortletWindowId, IPortletWindowId failedPortletWindowId, String failedPortletFname, Exception cause) {
        this.portletRenderer = portletRenderer;
        this.interceptors = interceptors;
        this.request = request;
        this.response = response;
        this.errorPortletWindowId = errorPortletWindowId;
        this.failedPortletWindowId = failedPortletWindowId;
        this.failedPortletFname = failedPortletFname;
        this.cause = cause;
    }

    public IPortletExecutionContext.ExecutionType getExecutionType() {
        return IPortletExecutionContext.ExecutionType.FAILURE;
    }

    public void submit() {
        if (this.submitted > 0L) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " for " + this.getPortletWindowId() + " has already been submitted.");
        }
        this.submitted = System.currentTimeMillis();
        for (IPortletExecutionInterceptor interceptor : this.interceptors) {
            interceptor.preSubmit(this.request, this.response, (IPortletExecutionContext)this);
        }
    }

    private void doPostExecution(Exception e) {
        ListIterator listIterator = this.interceptors.listIterator(this.interceptors.size());
        while (listIterator.hasPrevious()) {
            IPortletExecutionInterceptor interceptor = (IPortletExecutionInterceptor)listIterator.previous();
            try {
                interceptor.postExecution(this.request, this.response, (IPortletExecutionContext)this, e);
            }
            catch (Throwable ex2) {
                this.logger.error((Object)"HandlerInterceptor.postExecution threw exception", ex2);
            }
        }
    }

    public String getOutput(long timeout) throws Exception {
        this.get(timeout);
        return this.output;
    }

    public long waitForStart(long timeout) throws InterruptedException {
        this.renderError(timeout);
        return this.submitted;
    }

    public synchronized PortletRenderResult get(long timeout) throws Exception {
        this.retrieved = true;
        this.renderError(timeout);
        return this.portletRenderResult;
    }

    public void cancel() {
    }

    public int getCancelCount() {
        return 0;
    }

    protected synchronized void renderError(long timeout) {
        if (this.completed > 0L) {
            return;
        }
        HttpServletRequest wrappedRequest = PortletHttpServletRequestWrapper.create((HttpServletRequest)this.request);
        wrappedRequest.setAttribute(PortletErrorController.REQUEST_ATTRIBUTE__CURRENT_FAILED_PORTLET_WINDOW_ID, (Object)this.failedPortletWindowId);
        wrappedRequest.setAttribute(PortletErrorController.REQUEST_ATTRIBUTE__CURRENT_EXCEPTION_CAUSE, (Object)this.cause);
        for (IPortletExecutionInterceptor interceptor : this.interceptors) {
            interceptor.preExecution(this.request, this.response, (IPortletExecutionContext)this);
        }
        try {
            String characterEncoding = this.response.getCharacterEncoding();
            RenderPortletOutputHandler renderPortletOutputHandler = new RenderPortletOutputHandler(characterEncoding);
            this.portletRenderResult = this.portletRenderer.doRenderMarkup(this.errorPortletWindowId, wrappedRequest, this.response, (PortletOutputHandler)renderPortletOutputHandler);
            this.doPostExecution(null);
            this.output = renderPortletOutputHandler.getOutput();
        }
        catch (Exception e) {
            this.doPostExecution(e);
            this.logger.error((Object)"Exception while dispatching to error handling portlet", (Throwable)e);
            this.output = "Error Portlet Unavailable. Please contact your portal adminstrators.";
        }
        this.completed = System.currentTimeMillis();
    }

    public Object setExecutionAttribute(String name, Object value) {
        if (value == null) {
            return this.executionAttributes.remove(name);
        }
        return this.executionAttributes.put(name, value);
    }

    public Object getExecutionAttribute(String name) {
        return this.executionAttributes.get(name);
    }

    public IPortletWindowId getPortletWindowId() {
        return this.failedPortletWindowId;
    }

    public String getPortletFname() {
        return this.failedPortletFname;
    }

    public boolean isSubmitted() {
        return this.submitted > 0L;
    }

    public boolean isStarted() {
        return this.submitted > 0L;
    }

    public boolean isComplete() {
        return this.completed > 0L;
    }

    public boolean isRetrieved() {
        return this.retrieved;
    }

    public long getSubmittedTime() {
        return this.submitted;
    }

    public long getStartedTime() {
        return this.submitted;
    }

    public long getCompleteTime() {
        return this.completed;
    }

    public long getWait() {
        return 0L;
    }

    public long getDuration() {
        return this.completed - this.submitted;
    }

    public long getApplicableTimeout() {
        return -1L;
    }
}

