/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering.worker;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionContext;
import org.jasig.portal.portlet.rendering.worker.PortletExecutionInterceptorAdaptor;
import org.springframework.beans.factory.BeanNameAware;

public abstract class ThreadLocalPortletExecutionInterceptor<T>
extends PortletExecutionInterceptorAdaptor
implements BeanNameAware {
    private static final String CURRENT_THREAD = ThreadLocalPortletExecutionInterceptor.class.getName() + ".CURRENT_THREAD";
    private String contextAttributeName = this.getClass().getName();

    protected abstract T getThreadLocalValue(HttpServletRequest var1, HttpServletResponse var2, IPortletExecutionContext var3);

    protected abstract void setThreadLocalValue(HttpServletRequest var1, HttpServletResponse var2, IPortletExecutionContext var3, T var4);

    public void setContextAttributeName(String contextAttributeName) {
        this.contextAttributeName = contextAttributeName;
    }

    public void setBeanName(String name) {
        if (this.contextAttributeName != null) {
            this.contextAttributeName = name;
        }
    }

    public final void preSubmit(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context) {
        context.setExecutionAttribute(CURRENT_THREAD, (Object)Thread.currentThread());
        Object preSubmitData = this.getThreadLocalValue(request, response, context);
        context.setExecutionAttribute(this.contextAttributeName, preSubmitData);
    }

    public final void preExecution(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context) {
        Thread currentThread = (Thread)context.getExecutionAttribute(CURRENT_THREAD);
        if (Thread.currentThread() != currentThread) {
            Object preExecuteData = this.getThreadLocalValue(request, response, context);
            Object preSubmitData = context.getExecutionAttribute(this.contextAttributeName);
            this.setThreadLocalValue(request, response, context, preSubmitData);
            context.setExecutionAttribute(this.contextAttributeName, preExecuteData);
        }
    }

    public final void postExecution(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context, Exception e) {
        Thread currentThread = (Thread)context.getExecutionAttribute(CURRENT_THREAD);
        if (Thread.currentThread() != currentThread) {
            Object preExecuteData = context.getExecutionAttribute(this.contextAttributeName);
            this.setThreadLocalValue(request, response, context, preExecuteData);
        }
    }
}

