/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.container.driver.PortletInvocationEvent;
import org.apache.pluto.container.driver.PortletInvocationListener;
import org.jasig.portal.portlet.session.PortletSessionExpirationManager;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.stereotype.Service;
import org.springframework.web.util.WebUtils;

@Service(value="portletSessionExpirationManager")
public class PortletSessionExpirationManager
implements PortletInvocationListener,
ApplicationListener<HttpSessionDestroyedEvent> {
    public static final String PORTLET_SESSIONS_MAP = PortletSessionExpirationManager.class.getName() + ".PORTLET_SESSIONS";
    private static final String ALREADY_INVALIDATING_SESSION_ATTRIBUTE = PortletSessionExpirationManager.class.getName() + ".ALREADY_INVALIDATING_SESSION_ATTRIBUTE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortalRequestUtils portalRequestUtils;

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnd(PortletInvocationEvent event) {
        PortletRequest portletRequest = event.getPortletRequest();
        PortletSession portletSession = portletRequest.getPortletSession(false);
        if (portletSession == null) {
            return;
        }
        HttpServletRequest portalRequest = this.portalRequestUtils.getPortletHttpRequest(portletRequest);
        HttpSession portalSession = portalRequest.getSession();
        if (portalSession != null) {
            NonSerializableMapHolder portletSessions;
            Object object = WebUtils.getSessionMutex((HttpSession)portalSession);
            synchronized (object) {
                portletSessions = (NonSerializableMapHolder)portalSession.getAttribute(PORTLET_SESSIONS_MAP);
                if (portletSessions == null || !portletSessions.isValid()) {
                    portletSessions = new NonSerializableMapHolder(new ConcurrentHashMap());
                    portalSession.setAttribute(PORTLET_SESSIONS_MAP, (Object)portletSessions);
                }
            }
            String contextPath = portletRequest.getContextPath();
            portletSessions.put((Object)contextPath, (Object)portletSession);
        }
    }

    public void onApplicationEvent(HttpSessionDestroyedEvent event) {
        HttpSession session = event.getSession();
        Map portletSessions = (Map)session.getAttribute(PORTLET_SESSIONS_MAP);
        if (portletSessions == null) {
            return;
        }
        if (session.getAttribute(ALREADY_INVALIDATING_SESSION_ATTRIBUTE) != null) {
            return;
        }
        session.setAttribute(ALREADY_INVALIDATING_SESSION_ATTRIBUTE, (Object)Boolean.TRUE);
        for (Map.Entry portletSessionEntry : portletSessions.entrySet()) {
            String contextPath = (String)portletSessionEntry.getKey();
            PortletSession portletSession = (PortletSession)portletSessionEntry.getValue();
            try {
                portletSession.invalidate();
            }
            catch (IllegalStateException e) {
                this.logger.info((Object)("PortletSession with id '" + portletSession.getId() + "' for context '" + contextPath + "' has already been invalidated."));
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed to invalidate PortletSession with id '" + portletSession.getId() + "' for context '" + contextPath + "'"), (Throwable)e);
            }
        }
    }

    public void onBegin(PortletInvocationEvent event) {
    }

    public void onError(PortletInvocationEvent event, Throwable t) {
    }
}

