/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.account;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.i18n.ILocaleStore;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.persondir.ILocalAccountDao;
import org.jasig.portal.persondir.ILocalAccountPerson;
import org.jasig.portal.portletpublishing.xml.Preference;
import org.jasig.portal.portlets.StringListAttribute;
import org.jasig.portal.portlets.account.GroupedPersonAttribute;
import org.jasig.portal.portlets.account.GroupedPersonAttributeByNameComparator;
import org.jasig.portal.portlets.account.PersonForm;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.IPortalPasswordService;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.UrlType;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupDir;

@Component(value="userAccountHelper")
public class UserAccountHelper {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String templateDir = "properties/templates";
    private String passwordResetTemplate = "passwordReset";
    private ILocaleStore localeStore;
    private ILocalAccountDao accountDao;
    private IPortalPasswordService passwordService;
    private List<Preference> accountEditAttributes;
    private JavaMailSenderImpl mailSender;
    private IPortalUrlProvider urlProvider;
    private MessageSource messageSource;
    private String portalEmailAddress;
    private IPersonManager personManager;
    private IGroupListHelper groupListHelper;

    @Autowired
    public void setLocaleStore(ILocaleStore localeStore) {
        this.localeStore = localeStore;
    }

    @Autowired
    public void setLocalAccountDao(ILocalAccountDao accountDao) {
        this.accountDao = accountDao;
    }

    @Autowired
    public void setPortalPasswordService(IPortalPasswordService passwordService) {
        this.passwordService = passwordService;
    }

    @Resource(name="accountEditAttributes")
    public void setAccountEditAttributes(List<Preference> accountEditAttributes) {
        this.accountEditAttributes = Collections.unmodifiableList(accountEditAttributes);
    }

    @Autowired
    public void setMailSender(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
    }

    @Autowired
    public void setPortalUrlProvider(IPortalUrlProvider urlProvider) {
        this.urlProvider = urlProvider;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Resource(name="portalEmailAddress")
    public void setPortalEmailAddress(String portalEmailAddress) {
        this.portalEmailAddress = portalEmailAddress;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    public PersonForm getNewAccountForm() {
        PersonForm form = new PersonForm(this.accountEditAttributes);
        Set attributeNames = this.accountDao.getCurrentAttributeNames();
        for (String name : attributeNames) {
            form.getAttributes().put(name, new StringListAttribute(Collections.emptyList()));
        }
        return form;
    }

    public PersonForm getForm(String username) {
        ILocalAccountPerson person = this.accountDao.getPerson(username);
        PersonForm form = new PersonForm(this.accountEditAttributes);
        form.setUsername(person.getName());
        form.setId(person.getId());
        Set attributeNames = this.accountDao.getCurrentAttributeNames();
        for (String name : attributeNames) {
            ArrayList<String> values = new ArrayList<String>();
            List attrValues = person.getAttributeValues(name);
            if (attrValues != null) {
                for (Object value : person.getAttributeValues(name)) {
                    values.add((String)value);
                }
            }
            form.getAttributes().put(name, new StringListAttribute(values));
        }
        return form;
    }

    protected boolean isLocalAccount(String username) {
        ILocalAccountPerson person = this.accountDao.getPerson(username);
        return person != null;
    }

    public List<JsonEntityBean> getParentGroups(String target) {
        IEntity member = GroupService.getEntity((String)target, IPerson.class);
        Iterator iterator = member.getAllContainingGroups();
        ArrayList<JsonEntityBean> parents = new ArrayList<JsonEntityBean>();
        while (iterator.hasNext()) {
            parents.add(this.groupListHelper.getEntity((IGroupMember)iterator.next()));
        }
        Collections.sort(parents);
        return parents;
    }

    public boolean canEditUser(IPerson currentUser, String target) {
        if (!this.isLocalAccount(target)) {
            return false;
        }
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        if (currentUser.getName().equals(target) && ap.hasPermission("UP_USERS", "EDIT_USER", "SELF")) {
            return true;
        }
        return ap.hasPermission("UP_USERS", "EDIT_USER", target);
    }

    public List<Preference> getEditableUserAttributes(IPerson currentUser) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        ArrayList<Preference> allowedAttributes = new ArrayList<Preference>();
        for (Preference attr : this.accountEditAttributes) {
            if (!ap.hasPermission("UP_USERS", "EDIT_USER_ATTRIBUTE", attr.getName())) continue;
            allowedAttributes.add(attr);
        }
        return allowedAttributes;
    }

    public List<GroupedPersonAttribute> groupPersonAttributes(IPersonAttributes user, HttpServletRequest request) {
        Locale locale = this.getCurrentUserLocale(request);
        ArrayList<GroupedPersonAttribute> displayAttributes = new ArrayList<GroupedPersonAttribute>();
        for (Map.Entry attr : user.getAttributes().entrySet()) {
            String displayName = this.messageSource.getMessage("attribute.displayName.".concat((String)attr.getKey()), new Object[0], (String)attr.getKey(), locale);
            boolean found = false;
            for (GroupedPersonAttribute displayAttribute : displayAttributes) {
                if (!displayAttribute.getDisplayName().equals(displayName) || !((List)attr.getValue()).equals(displayAttribute.getValues())) continue;
                displayAttribute.getAttributeNames().add(attr.getKey());
                found = true;
                break;
            }
            if (found) continue;
            GroupedPersonAttribute displayAttribute = new GroupedPersonAttribute(displayName, (List)attr.getValue(), (String)attr.getKey());
            displayAttributes.add(displayAttribute);
        }
        Collections.sort(displayAttributes, new GroupedPersonAttributeByNameComparator());
        return displayAttributes;
    }

    public boolean canDeleteUser(IPerson currentUser, String target) {
        if (!this.isLocalAccount(target)) {
            return false;
        }
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission("UP_USERS", "DELETE_USER", target);
    }

    public void deleteAccount(IPerson currentUser, String target) {
        if (!this.canDeleteUser(currentUser, target)) {
            throw new RuntimeException("Current user " + currentUser.getName() + " does not have permissions to update person " + target);
        }
        ILocalAccountPerson person = this.accountDao.getPerson(target);
        this.accountDao.deleteAccount(person);
        this.log.info((Object)("Account " + person.getName() + " successfully deleted"));
    }

    public void updateAccount(IPerson currentUser, PersonForm form) {
        ILocalAccountPerson account;
        if (form.getId() < 0L) {
            account = this.accountDao.getPerson(form.getUsername());
            if (account == null) {
                account = this.accountDao.createPerson(form.getUsername());
            }
        } else {
            account = this.accountDao.getPerson(form.getId());
        }
        if (!this.canEditUser(currentUser, account.getName())) {
            throw new RuntimeException("Current user " + currentUser.getName() + " does not have permissions to update person " + account.getName());
        }
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        List editableAttributes = this.getEditableUserAttributes(currentUser);
        for (Preference editableAttribute : editableAttributes) {
            String attributeName = editableAttribute.getName();
            if (!ap.hasPermission("UP_USERS", "EDIT_USER_ATTRIBUTE", attributeName)) {
                throw new RuntimeException("Current user " + currentUser.getName() + " does not have permissions to edit attribute " + attributeName);
            }
            if (form.getAttributes().get(attributeName) == null || ((StringListAttribute)form.getAttributes().get(attributeName)).isBlank()) {
                account.removeAttribute(attributeName);
                continue;
            }
            account.setAttribute(attributeName, ((StringListAttribute)form.getAttributes().get(attributeName)).getValue());
        }
        if (StringUtils.isNotBlank((String)form.getPassword())) {
            account.setPassword(this.passwordService.encryptPassword(form.getPassword()));
            account.setLastPasswordChange(new Date());
            account.removeAttribute("loginToken");
        }
        this.accountDao.updateAccount(account);
        this.log.info((Object)("Account " + account.getName() + " successfully updated"));
    }

    public String getRandomToken() {
        String token = RandomStringUtils.randomAlphanumeric((int)20);
        return token;
    }

    public boolean validateLoginToken(String username, String token) {
        ILocalAccountPerson person = this.accountDao.getPerson(username);
        if (person != null) {
            Object recordedToken = person.getAttributeValue("loginToken");
            if (recordedToken != null && recordedToken.equals(token)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Successfully validated security token for user:  " + username));
                }
                return true;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Unable to validate security token;  recordedToken=" + recordedToken + ", submitted token=" + token));
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Unable to validate security token;  person not found:  " + username));
        }
        return false;
    }

    public void sendLoginToken(HttpServletRequest request, ILocalAccountPerson account) {
        IPerson person = this.personManager.getPerson(request);
        Locale[] userLocales = this.localeStore.getUserLocales(person);
        LocaleManager localeManager = new LocaleManager(person, userLocales);
        Locale locale = localeManager.getLocales()[0];
        IPortalUrlBuilder builder = this.urlProvider.getPortalUrlBuilderByPortletFName(request, "reset-password", UrlType.RENDER);
        IPortletUrlBuilder portletUrlBuilder = builder.getTargetedPortletUrlBuilder();
        portletUrlBuilder.addParameter("username", new String[]{account.getName()});
        portletUrlBuilder.addParameter("loginToken", new String[]{(String)account.getAttributeValue("loginToken")});
        portletUrlBuilder.setPortletMode(PortletMode.VIEW);
        portletUrlBuilder.setWindowState(WindowState.MAXIMIZED);
        StringBuffer url = new StringBuffer();
        url.append(request.getScheme());
        url.append("://").append(request.getServerName());
        int port = request.getServerPort();
        if (port != 80 && port != 443) {
            url.append(":").append(port);
        }
        url.append(builder.getUrlString());
        this.log.debug((Object)("Sending password reset instructions to user with url " + url.toString()));
        String emailAddress = (String)account.getAttributeValue("mail");
        STGroupDir group = new STGroupDir(this.templateDir, '$', '$');
        ST template = group.getInstanceOf(this.passwordResetTemplate);
        template.add("displayName", person.getAttribute("displayName"));
        template.add("url", (Object)url.toString());
        MimeMessage message = this.mailSender.createMimeMessage();
        String body = template.render();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(emailAddress);
            helper.setText(body, true);
            helper.setSubject(this.messageSource.getMessage("reset.your.password", new Object[0], locale));
            helper.setFrom(this.portalEmailAddress, this.messageSource.getMessage("portal.name", new Object[0], locale));
            this.log.debug((Object)("Sending message to " + emailAddress + " from " + Arrays.toString(message.getFrom()) + " subject " + message.getSubject()));
            this.mailSender.send(message);
        }
        catch (MailException e) {
            this.log.error((Object)"Unable to send password reset email ", (Throwable)e);
        }
        catch (MessagingException e) {
            this.log.error((Object)"Unable to send password reset email ", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)"Unable to send password reset email ", (Throwable)e);
        }
    }

    public void createPassword(PersonForm form, String token) {
        String username = form.getUsername();
        if (!this.validateLoginToken(username, token)) {
            throw new RuntimeException("Attempt to set a password for user '" + username + "' without a valid security token");
        }
        String password = form.getPassword();
        if (StringUtils.isNotBlank((String)password)) {
            ILocalAccountPerson account = this.accountDao.getPerson(username);
            account.setPassword(this.passwordService.encryptPassword(password));
            account.setLastPasswordChange(new Date());
            account.removeAttribute("loginToken");
            this.accountDao.updateAccount(account);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Password created for account:  " + account));
            }
        } else {
            throw new RuntimeException("Attempt to set a password for user '" + form.getUsername() + "' but the password was blank");
        }
    }

    protected Locale getCurrentUserLocale(HttpServletRequest request) {
        IPerson person = this.personManager.getPerson(request);
        Locale[] userLocales = this.localeStore.getUserLocales(person);
        LocaleManager localeManager = new LocaleManager(person, userLocales);
        Locale locale = localeManager.getLocales()[0];
        return locale;
    }
}

