/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.fragmentadmin;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.PortletRequest;
import org.jasig.portal.layout.dlm.ConfigurationLoader;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.security.IdentitySwapperManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.webflow.execution.RequestContext;

@Service(value="fragmentAdministrationHelper")
public class FragmentAdministrationHelper {
    private ConfigurationLoader configurationLoader;
    private IdentitySwapperManager identitySwapperManager;

    @Autowired
    public void setConfigurationLoader(ConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
    }

    @Autowired
    public void setIdentitySwapperManager(IdentitySwapperManager identitySwapperManager) {
        this.identitySwapperManager = identitySwapperManager;
    }

    public Map<String, String> getAuthorizedDlmFragments(String remoteUser) {
        List fragments = this.configurationLoader.getFragments();
        TreeMap<String, String> results = new TreeMap<String, String>();
        for (FragmentDefinition frag : fragments) {
            if (!this.identitySwapperManager.canImpersonateUser(remoteUser, frag.getOwnerId())) continue;
            results.put(frag.getOwnerId(), frag.getName());
        }
        return results;
    }

    public String swapToFragmentOwner(String remoteUser, String targetFragmentOwner, RequestContext requestContext) {
        PortletRequest portletRequest = (PortletRequest)requestContext.getExternalContext().getNativeRequest();
        this.identitySwapperManager.impersonateUser(portletRequest, remoteUser, targetFragmentOwner);
        return "yes";
    }
}

