/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.lookup;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.portlets.lookup.IPersonLookupHelper;
import org.jasig.portal.portlets.search.DisplayNameComparator;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.NamedPersonImpl;
import org.springframework.webflow.context.ExternalContext;

public class PersonLookupHelperImpl
implements IPersonLookupHelper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPersonAttributeDao personAttributeDao;
    private int maxResults;

    public IPersonAttributeDao getPersonAttributeDao() {
        return this.personAttributeDao;
    }

    public void setPersonAttributeDao(IPersonAttributeDao personLookupDao) {
        this.personAttributeDao = personLookupDao;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Set<String> getQueryAttributes(ExternalContext externalContext) {
        AbstractSet queryAttributes;
        PortletRequest portletRequest = (PortletRequest)externalContext.getNativeRequest();
        PortletPreferences preferences = portletRequest.getPreferences();
        String[] configuredAttributes = preferences.getValues("person-lookup.personLookup.queryAttributes", null);
        String[] excludedAttributes = preferences.getValues("person-lookup.personLookup.queryAttributes.exclude", null);
        if (configuredAttributes != null) {
            queryAttributes = new LinkedHashSet<String>(Arrays.asList(configuredAttributes));
        } else {
            Set availableAttributes = this.personAttributeDao.getAvailableQueryAttributes();
            queryAttributes = new TreeSet(availableAttributes);
        }
        if (excludedAttributes != null) {
            for (String excludedAttribute : excludedAttributes) {
                queryAttributes.remove(excludedAttribute);
            }
        }
        return queryAttributes;
    }

    public Set<String> getDisplayAttributes(ExternalContext externalContext) {
        LinkedHashSet<String> displayAttributes;
        PortletRequest portletRequest = (PortletRequest)externalContext.getNativeRequest();
        PortletPreferences preferences = portletRequest.getPreferences();
        String[] configuredAttributes = preferences.getValues("person-lookup.personDetails.detailsAttributes", null);
        String[] excludedAttributes = preferences.getValues("person-lookup.personDetails.detailsAttributes.exclude", null);
        if (configuredAttributes != null) {
            displayAttributes = new LinkedHashSet<String>();
            displayAttributes.addAll(Arrays.asList(configuredAttributes));
        } else {
            displayAttributes = new TreeSet(this.personAttributeDao.getPossibleUserAttributeNames());
        }
        if (excludedAttributes != null) {
            for (String excludedAttribute : excludedAttributes) {
                displayAttributes.remove(excludedAttribute);
            }
        }
        return displayAttributes;
    }

    public IPersonAttributes getSelf(ExternalContext externalContext) {
        PortletRequest portletRequest = (PortletRequest)externalContext.getNativeRequest();
        String username = portletRequest.getRemoteUser();
        return this.personAttributeDao.getPerson(username);
    }

    public List<IPersonAttributes> searchForPeople(IPerson searcher, Map<String, Object> query) {
        IAuthorizationPrincipal principal = this.getPrincipalForUser(searcher);
        Set permittedAttributes = this.getAvailableAttributes(principal);
        HashMap<String, Object> inUseQuery = new HashMap<String, Object>();
        for (Map.Entry<String, Object> queryEntry : query.entrySet()) {
            String attr = queryEntry.getKey();
            if (permittedAttributes.contains(attr)) {
                inUseQuery.put(attr, queryEntry.getValue());
                continue;
            }
            this.logger.warn((Object)("User '" + searcher.getName() + "' attempted searching on attribute '" + attr + "' which is not allowed in the current configuration. The attribute will be ignored."));
        }
        if (inUseQuery.keySet().size() == 0) {
            throw new IllegalArgumentException("Search query is empty");
        }
        Set people = this.personAttributeDao.getPeople(inUseQuery);
        if (people == null) {
            return Collections.emptyList();
        }
        List<Object> list = new ArrayList<IPersonAttributes>();
        for (IPersonAttributes person : people) {
            IPersonAttributes visiblePerson = this.getVisiblePerson(principal, person, permittedAttributes);
            if (visiblePerson == null) continue;
            list.add(visiblePerson);
        }
        Collections.sort(list, new DisplayNameComparator());
        if (list.size() > this.maxResults) {
            list = list.subList(0, this.maxResults);
        }
        return list;
    }

    public IPersonAttributes findPerson(IPerson searcher, String username) {
        IAuthorizationPrincipal principal = this.getPrincipalForUser(searcher);
        Set permittedAttributes = this.getAvailableAttributes(principal);
        IPersonAttributes person = this.personAttributeDao.getPerson(username);
        if (person == null) {
            this.logger.info((Object)("No user found with username matching " + username));
            return null;
        }
        return this.getVisiblePerson(principal, person, permittedAttributes);
    }

    protected IAuthorizationPrincipal getPrincipalForUser(IPerson person) {
        EntityIdentifier ei = person.getEntityIdentifier();
        return AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
    }

    protected Set<String> getAvailableAttributes(IAuthorizationPrincipal principal) {
        Set attributeNames = this.personAttributeDao.getPossibleUserAttributeNames();
        return this.getAvailableAttributes(principal, attributeNames);
    }

    protected Set<String> getAvailableAttributes(IAuthorizationPrincipal principal, Set<String> attributeNames) {
        HashSet<String> permittedAttributes = new HashSet<String>();
        for (String attr : attributeNames) {
            if (!principal.hasPermission("UP_USERS", "VIEW_USER_ATTRIBUTE", attr)) continue;
            permittedAttributes.add(attr);
        }
        return permittedAttributes;
    }

    protected IPersonAttributes getVisiblePerson(IAuthorizationPrincipal principal, IPersonAttributes person, Set<String> permittedAttributes) {
        if (person.getName() != null && principal.hasPermission("UP_USERS", "VIEW_USER", person.getName())) {
            HashMap<String, List> visibleAttributes = new HashMap<String, List>();
            for (String attr : person.getAttributes().keySet()) {
                if (!permittedAttributes.contains(attr)) continue;
                visibleAttributes.put(attr, person.getAttributeValues(attr));
            }
            NamedPersonImpl visiblePerson = new NamedPersonImpl(person.getName(), visibleAttributes);
            return visiblePerson;
        }
        this.logger.debug((Object)("Principal " + principal.getKey() + " does not have permissions to view user " + person.getName()));
        return null;
    }
}

