/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.search;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.portal.portlet.PortletUtils;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlets.search.IPortalSearchService;
import org.jasig.portal.portlets.search.PortalSearchResults;
import org.jasig.portal.portlets.search.SearchPortletController;
import org.jasig.portal.search.PortletUrl;
import org.jasig.portal.search.PortletUrlParameter;
import org.jasig.portal.search.PortletUrlType;
import org.jasig.portal.search.SearchConstants;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portal.search.SearchResults;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.UrlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class SearchPortletController {
    private static final String SEARCH_RESULTS_CACHE_NAME = SearchPortletController.class.getName() + ".searchResultsCache";
    private static final String SEARCH_COUNTER_NAME = SearchPortletController.class.getName() + ".searchCounter";
    private static final String SEARCH_HANDLED_CACHE_NAME = SearchPortletController.class.getName() + ".searchHandledCache";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPortalUrlProvider portalUrlProvider;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortalRequestUtils portalRequestUtils;
    private List<IPortalSearchService> searchServices;
    private Map<String, Set<String>> resultTypeMappings = Collections.emptyMap();
    private List<String> tabKeys = Collections.emptyList();
    private String defaultTabKey = "portal.results";
    private int maximumSearchesPerMinute = 18;

    @Resource(name="searchServices")
    public void setPortalSearchServices(List<IPortalSearchService> searchServices) {
        this.searchServices = searchServices;
    }

    @Value(value="${org.jasig.portal.portlets.searchSearchPortletController.defaultTabKey:portal.results}")
    public void setDefaultTabKey(String defaultTabKey) {
        this.defaultTabKey = defaultTabKey;
    }

    @Value(value="${org.jasig.portal.portlets.searchSearchPortletController.maximumSearchesPerMinute:18}")
    public void setMaximumSearchesPerMinute(int maximumSearchesPerMinute) {
        this.maximumSearchesPerMinute = maximumSearchesPerMinute;
    }

    @Resource(name="searchTabs")
    public void setSearchTabs(Map<String, Object> searchTabMappings) {
        LinkedHashMap resultTypeMappingsBuilder = new LinkedHashMap();
        ArrayList<String> tabKeysBuilder = new ArrayList<String>(searchTabMappings.size());
        for (Map.Entry<String, Object> tabMapping : searchTabMappings.entrySet()) {
            String tabKey = tabMapping.getKey();
            tabKeysBuilder.add(tabKey);
            Object resultTypes = tabMapping.getValue();
            if (resultTypes instanceof Collection) {
                for (String resultType : (Collection)resultTypes) {
                    this.addTabKey(resultTypeMappingsBuilder, tabKey, resultType);
                }
                continue;
            }
            String resultType = (String)resultTypes;
            this.addTabKey(resultTypeMappingsBuilder, tabKey, resultType);
        }
        this.resultTypeMappings = resultTypeMappingsBuilder;
        this.tabKeys = tabKeysBuilder;
    }

    protected void addTabKey(Map<String, Set<String>> resultTypeMappingsBuilder, String tabKey, String resultType) {
        Set<String> tabKeys = resultTypeMappingsBuilder.get(resultType);
        if (tabKeys == null) {
            tabKeys = new LinkedHashSet<String>();
            resultTypeMappingsBuilder.put(resultType, tabKeys);
        }
        tabKeys.add(tabKey);
    }

    @Autowired
    public void setPortalUrlProvider(IPortalUrlProvider urlProvider) {
        this.portalUrlProvider = urlProvider;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ActionMapping
    public void performSearch(@RequestParam(value="query") String query, ActionRequest request, ActionResponse response) {
        Cache searchResultsCache;
        Cache searchCounterCache;
        PortletSession session = request.getPortletSession();
        String queryId = RandomStringUtils.randomAlphanumeric((int)32);
        Object object = org.springframework.web.portlet.util.PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object) {
            searchCounterCache = (Cache)session.getAttribute(SEARCH_COUNTER_NAME);
            if (searchCounterCache == null) {
                searchCounterCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
                session.setAttribute(SEARCH_COUNTER_NAME, (Object)searchCounterCache);
            }
        }
        searchCounterCache.put((Object)queryId, (Object)Boolean.TRUE);
        if (searchCounterCache.size() > (long)this.maximumSearchesPerMinute) {
            searchCounterCache.cleanUp();
            if (searchCounterCache.size() > (long)this.maximumSearchesPerMinute) {
                response.setRenderParameter("hitMaxQueries", Boolean.TRUE.toString());
                response.setRenderParameter("query", query);
                return;
            }
        }
        SearchRequest queryObj = new SearchRequest();
        queryObj.setQueryId(queryId);
        queryObj.setSearchTerms(query);
        PortalSearchResults results = new PortalSearchResults(this.defaultTabKey, this.resultTypeMappings);
        Object object2 = org.springframework.web.portlet.util.PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object2) {
            searchResultsCache = (Cache)session.getAttribute(SEARCH_RESULTS_CACHE_NAME);
            if (searchResultsCache == null) {
                searchResultsCache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
                session.setAttribute(SEARCH_RESULTS_CACHE_NAME, (Object)searchResultsCache);
            }
        }
        searchResultsCache.put((Object)queryId, (Object)results);
        response.setEvent(SearchConstants.SEARCH_REQUEST_QNAME, (Serializable)queryObj);
        response.setRenderParameter("queryId", queryId);
        response.setRenderParameter("query", query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventMapping(value="{https://source.jasig.org/schemas/uportal/search}SearchRequest")
    public void handleSearchRequest(EventRequest request, EventResponse response) {
        ConcurrentMap searchHandledCache;
        Event event = request.getEvent();
        SearchRequest searchQuery = (SearchRequest)event.getValue();
        PortletSession session = request.getPortletSession();
        Object object = org.springframework.web.portlet.util.PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object) {
            searchHandledCache = (ConcurrentMap)session.getAttribute(SEARCH_HANDLED_CACHE_NAME, 1);
            if (searchHandledCache == null) {
                searchHandledCache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterAccess(5L, TimeUnit.MINUTES).build().asMap();
                session.setAttribute(SEARCH_HANDLED_CACHE_NAME, (Object)searchHandledCache, 1);
            }
        }
        String queryId = searchQuery.getQueryId();
        if (searchHandledCache.putIfAbsent(queryId, Boolean.TRUE) != null) {
            return;
        }
        SearchResults results = new SearchResults();
        results.setQueryId(queryId);
        results.setWindowId(request.getWindowID());
        List searchResultList = results.getSearchResult();
        for (IPortalSearchService searchService : this.searchServices) {
            try {
                SearchResults serviceResults = searchService.getSearchResults((PortletRequest)request, searchQuery);
                searchResultList.addAll(serviceResults.getSearchResult());
            }
            catch (Exception e) {
                this.logger.warn(searchService.getClass() + " threw an exception when searching, it will be ignored. " + searchQuery, (Throwable)e);
            }
        }
        if (!searchResultList.isEmpty()) {
            response.setEvent(SearchConstants.SEARCH_RESULTS_QNAME, (Serializable)results);
        }
    }

    @EventMapping(value="{https://source.jasig.org/schemas/uportal/search}SearchResults")
    public void handleSearchResult(EventRequest request) {
        Event event = request.getEvent();
        SearchResults portletSearchResults = (SearchResults)event.getValue();
        String queryId = portletSearchResults.getQueryId();
        PortalSearchResults results = this.getPortalSearchResults((PortletRequest)request, queryId);
        if (results == null) {
            this.logger.warn("No PortalSearchResults found for queryId " + queryId + ", ignoring search results: " + event);
            return;
        }
        String windowId = portletSearchResults.getWindowId();
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getPortletHttpRequest((PortletRequest)request);
        IPortletWindowId portletWindowId = this.portletWindowRegistry.getPortletWindowId(httpServletRequest, windowId);
        this.addSearchResults(portletSearchResults, results, httpServletRequest, portletWindowId);
    }

    @RequestMapping
    public String showSearchForm(PortletRequest request) {
        boolean isMobile = this.isMobile(request);
        return isMobile ? "/jsp/Search/mobileSearch" : "/jsp/Search/search";
    }

    @RequestMapping(params={"query", "queryId"})
    public ModelAndView showSearchResults(PortletRequest request, @RequestParam(value="query") String query, @RequestParam(value="queryId") String queryId) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("query", query);
        PortalSearchResults portalSearchResults = this.getPortalSearchResults(request, queryId);
        ConcurrentMap results = portalSearchResults.getResults();
        model.put("results", results);
        model.put("defaultTabKey", this.defaultTabKey);
        model.put("tabKeys", this.tabKeys);
        boolean isMobile = this.isMobile(request);
        String viewName = isMobile ? "/jsp/Search/mobileSearch" : "/jsp/Search/search";
        return new ModelAndView(viewName, model);
    }

    @RequestMapping(params={"query", "hitMaxQueries"})
    public ModelAndView showSearchError(PortletRequest request, @RequestParam(value="query") String query, @RequestParam(value="hitMaxQueries") boolean hitMaxQueries) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("query", query);
        model.put("hitMaxQueries", hitMaxQueries);
        boolean isMobile = this.isMobile(request);
        String viewName = isMobile ? "/jsp/Search/mobileSearch" : "/jsp/Search/search";
        return new ModelAndView(viewName, model);
    }

    private PortalSearchResults getPortalSearchResults(PortletRequest request, String queryId) {
        PortletSession session = request.getPortletSession();
        Cache searchResultsCache = (Cache)session.getAttribute(SEARCH_RESULTS_CACHE_NAME);
        if (searchResultsCache == null) {
            return null;
        }
        return (PortalSearchResults)searchResultsCache.getIfPresent((Object)queryId);
    }

    private void addSearchResults(SearchResults portletSearchResults, PortalSearchResults results, HttpServletRequest httpServletRequest, IPortletWindowId portletWindowId) {
        for (SearchResult result : portletSearchResults.getSearchResult()) {
            String resultUrl = this.getResultUrl(httpServletRequest, result, portletWindowId);
            this.logger.debug("Created {} with from {}", (Object)resultUrl, (Object)result.getTitle());
            results.addPortletSearchResults(resultUrl, result);
        }
    }

    protected String getResultUrl(HttpServletRequest httpServletRequest, SearchResult result, IPortletWindowId portletWindowId) {
        PortletUrlType type;
        String externalUrl = result.getExternalUrl();
        if (externalUrl != null) {
            return externalUrl;
        }
        UrlType urlType = UrlType.RENDER;
        PortletUrl portletUrl = result.getPortletUrl();
        if (portletUrl != null && (type = portletUrl.getType()) != null) {
            switch (1.$SwitchMap$org$jasig$portal$search$PortletUrlType[type.ordinal()]) {
                case 1: {
                    urlType = UrlType.ACTION;
                    break;
                }
                default: {
                    urlType = UrlType.RENDER;
                    break;
                }
                case 3: {
                    urlType = UrlType.RESOURCE;
                }
            }
        }
        IPortalUrlBuilder portalUrlBuilder = this.portalUrlProvider.getPortalUrlBuilderByPortletWindow(httpServletRequest, portletWindowId, urlType);
        IPortletUrlBuilder portletUrlBuilder = portalUrlBuilder.getTargetedPortletUrlBuilder();
        if (portletUrl != null) {
            String windowState;
            String portletMode = portletUrl.getPortletMode();
            if (portletMode != null) {
                portletUrlBuilder.setPortletMode(PortletUtils.getPortletMode((String)portletMode));
            }
            if ((windowState = portletUrl.getWindowState()) != null) {
                portletUrlBuilder.setWindowState(PortletUtils.getWindowState((String)windowState));
            }
            for (PortletUrlParameter param : portletUrl.getParam()) {
                String name = param.getName();
                List values = param.getValue();
                portletUrlBuilder.addParameter(name, values.toArray(new String[values.size()]));
            }
        }
        return portalUrlBuilder.getUrlString();
    }

    public boolean isMobile(PortletRequest request) {
        String themeName = request.getProperty("themeName");
        return "UniversalityMobile".equals(themeName);
    }
}

