/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.sitemap;

import java.util.HashMap;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stax.StAXSource;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.jasig.portal.rendering.PipelineEventReader;
import org.jasig.portal.rendering.StAXPipelineComponent;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.xml.XsltPortalUrlProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class SitemapPortletController {
    public static final String USE_TAB_GROUPS = "USE_TAB_GROUPS";
    public static final String USER_LANG = "USER_LANG";
    private StAXPipelineComponent attributeIncorporationComponent;
    private IPortalRequestUtils portalRequestUtils;
    private XsltPortalUrlProvider xsltPortalUrlProvider;
    private boolean useTabGroups;

    @Autowired(required=true)
    @Qualifier(value="structureAttributeIncorporationComponent")
    public void setStructureAttributeIncorporationComponent(StAXPipelineComponent attributeIncorporationComponent) {
        this.attributeIncorporationComponent = attributeIncorporationComponent;
    }

    @Autowired(required=true)
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired
    public void setXsltPortalUrlProvider(XsltPortalUrlProvider xsltPortalUrlProvider) {
        this.xsltPortalUrlProvider = xsltPortalUrlProvider;
    }

    @Value(value="${org.jasig.portal.layout.useTabGroups}")
    public void setUseTabGroups(boolean useTabGroups) {
        this.useTabGroups = useTabGroups;
    }

    @RequestMapping
    public ModelAndView displaySitemap(PortletRequest request) throws XMLStreamException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getPortletHttpRequest(request);
        HttpServletResponse httpServletResponse = this.portalRequestUtils.getOriginalPortalResponse(request);
        PipelineEventReader reader = this.attributeIncorporationComponent.getEventReader(httpServletRequest, httpServletResponse);
        StAXSource source = new StAXSource((XMLEventReader)reader.getEventReader());
        model.put("source", source);
        model.put("CURRENT_REQUEST", httpServletRequest);
        model.put("XSLT_PORTAL_URL_PROVIDER", this.xsltPortalUrlProvider);
        model.put(USE_TAB_GROUPS, this.useTabGroups);
        model.put(USER_LANG, ObjectUtils.toString((Object)request.getLocale()));
        return new ModelAndView("sitemapView", model);
    }
}

