/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.statistics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.AggregationIntervalHelper;
import org.jasig.portal.events.aggr.BaseAggregation;
import org.jasig.portal.events.aggr.BaseAggregationDao;
import org.jasig.portal.events.aggr.BaseAggregationKey;
import org.jasig.portal.events.aggr.BaseGroupedAggregationDiscriminator;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMappingNameComparator;
import org.jasig.portal.portlets.statistics.BaseReportForm;
import org.jasig.portal.portlets.statistics.BaseStatisticsReportController;
import org.jasig.portal.portlets.statistics.CustomDateMidnightEditor;
import org.jasig.portal.portlets.statistics.JsonDataTable;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.portlet.ModelAndView;

public abstract class BaseStatisticsReportController<T extends BaseAggregation<K, D>, K extends BaseAggregationKey, D extends BaseGroupedAggregationDiscriminator, F extends BaseReportForm> {
    private static final List<AggregationInterval> PREFERRED_INTERVAL_ORDER = ImmutableList.of((Object)AggregationInterval.DAY, (Object)AggregationInterval.HOUR, (Object)AggregationInterval.FIVE_MINUTE, (Object)AggregationInterval.MINUTE, (Object)AggregationInterval.WEEK, (Object)AggregationInterval.MONTH, (Object)AggregationInterval.ACADEMIC_TERM, (Object)AggregationInterval.CALENDAR_QUARTER, (Object)AggregationInterval.YEAR);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AggregationIntervalHelper intervalHelper;
    @Autowired
    protected AggregatedGroupLookupDao aggregatedGroupDao;
    @org.springframework.beans.factory.annotation.Value(value="${org.jasig.portal.portlets.statistics.maxIntervals}")
    private int maxIntervals = 4000;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("M/d/yyyy").toFormatter();
        binder.registerCustomEditor(DateMidnight.class, (PropertyEditor)new CustomDateMidnightEditor(formatter, false));
    }

    @ModelAttribute(value="maxIntervals")
    public final Integer getMaxIntervals() {
        return this.maxIntervals;
    }

    @ModelAttribute(value="intervals")
    public final Set<AggregationInterval> getIntervals() {
        Set intervals = this.getBaseAggregationDao().getAggregationIntervals();
        TreeSet<AggregationInterval> sortedIntervals = new TreeSet<AggregationInterval>();
        sortedIntervals.addAll(intervals);
        return sortedIntervals;
    }

    @ModelAttribute(value="groups")
    public final Set<AggregatedGroupMapping> getGroups() {
        Set groupMappings = this.getBaseAggregationDao().getAggregatedGroupMappings();
        TreeSet<AggregatedGroupMapping> sortedGroupMappings = new TreeSet<AggregatedGroupMapping>(AggregatedGroupMappingNameComparator.INSTANCE);
        sortedGroupMappings.addAll(groupMappings);
        return sortedGroupMappings;
    }

    @ModelAttribute(value="reportRequest")
    public final F getReportForm(F report) {
        this.setReportFormDateRangeAndInterval(report);
        this.setReportFormGroups(report);
        this.initReportForm(report);
        return report;
    }

    @ModelAttribute(value="reportName")
    public abstract String getReportName();

    @ModelAttribute(value="reportDataResourceId")
    public abstract String getReportDataResourceId();

    protected final void setReportFormGroups(F report) {
        if (!report.getGroups().isEmpty()) {
            return;
        }
        Set groups = this.getGroups();
        if (!groups.isEmpty()) {
            report.getGroups().add(((AggregatedGroupMapping)groups.iterator().next()).getId());
        }
    }

    protected final void setReportFormDateRangeAndInterval(F report) {
        DateMidnight reportEnd;
        if (report.getInterval() == null) {
            report.setInterval(AggregationInterval.DAY);
            Set intervals = this.getIntervals();
            for (AggregationInterval preferredInterval : PREFERRED_INTERVAL_ORDER) {
                if (!intervals.contains(preferredInterval)) continue;
                report.setInterval(preferredInterval);
                break;
            }
        }
        if (report.getEnd() == null) {
            reportEnd = new DateMidnight();
            report.setEnd(reportEnd);
        } else {
            reportEnd = report.getEnd();
        }
        if (report.getStart() == null) {
            DateMidnight start;
            switch (1.$SwitchMap$org$jasig$portal$events$aggr$AggregationInterval[report.getInterval().ordinal()]) {
                case 1: {
                    start = reportEnd.minusDays(1);
                    break;
                }
                case 2: {
                    start = reportEnd.minusDays(2);
                    break;
                }
                case 3: {
                    start = reportEnd.minusWeeks(1);
                    break;
                }
                case 4: {
                    start = reportEnd.minusMonths(1);
                    break;
                }
                case 5: {
                    start = reportEnd.minusMonths(3);
                    break;
                }
                case 6: {
                    start = reportEnd.minusYears(1);
                    break;
                }
                case 7: {
                    start = reportEnd.minusYears(2);
                    break;
                }
                case 8: {
                    start = reportEnd.minusYears(2);
                    break;
                }
                case 9: {
                    start = reportEnd.minusYears(10);
                    break;
                }
                default: {
                    start = reportEnd.minusWeeks(1);
                }
            }
            report.setStart(start);
        }
    }

    protected void initReportForm(F report) {
    }

    protected abstract BaseAggregationDao<T, K> getBaseAggregationDao();

    protected abstract Set<K> createAggregationsQueryKeyset(Set<D> var1, F var2);

    protected abstract List<ColumnDescription> getColumnDescriptions(D var1, F var2);

    protected abstract Comparator<? super D> getDiscriminatorComparator();

    protected abstract Map<D, SortedSet<T>> createColumnDiscriminatorMap(F var1);

    protected abstract List<Value> createRowValues(T var1, F var2);

    protected final ModelAndView renderAggregationReport(F form) throws TypeMismatchException {
        String view;
        DataTable table = this.buildAggregationReport(form);
        switch (1.$SwitchMap$org$jasig$portal$portlets$statistics$BaseReportForm$OutputFormat[form.getFormat().ordinal()]) {
            case 1: {
                view = "dataTableCsvView";
                break;
            }
            case 2: {
                view = "dataTableHtmlView";
                break;
            }
            default: {
                view = "json";
            }
        }
        ModelAndView modelAndView = new ModelAndView(view, "table", (Object)table);
        String titleAugmentation = this.getReportTitleAugmentation(form);
        if (StringUtils.isNotBlank((String)titleAugmentation)) {
            modelAndView.addObject("titleAugmentation", (Object)this.getReportTitleAugmentation(form));
        }
        return modelAndView;
    }

    protected String getReportTitleAugmentation(F form) {
        return null;
    }

    protected final boolean showFullColumnHeaderDescriptions(F form) {
        boolean showFullHeaderDescriptions = false;
        switch (1.$SwitchMap$org$jasig$portal$portlets$statistics$BaseReportForm$OutputFormat[form.getFormat().ordinal()]) {
            case 1: {
                showFullHeaderDescriptions = true;
                break;
            }
            case 2: {
                showFullHeaderDescriptions = true;
                break;
            }
            default: {
                showFullHeaderDescriptions = false;
            }
        }
        return showFullHeaderDescriptions;
    }

    protected final DataTable buildAggregationReport(F form) throws TypeMismatchException {
        ColumnDescription dateTimeColumn;
        AggregationInterval interval = form.getInterval();
        DateMidnight start = form.getStart();
        DateMidnight end = form.getEnd();
        DateTime startDateTime = start.toDateTime();
        DateTime endDateTime = end.plusDays(1).toDateTime().minusSeconds(1);
        List reportTimes = this.intervalHelper.getIntervalStartDateTimesBetween(interval, startDateTime, endDateTime, this.maxIntervals);
        Map groupedAggregations = this.createColumnDiscriminatorMap(form);
        ValueType dateTimeColumnType = interval.isHasTimePart() ? (startDateTime.toDateMidnight().equals((Object)endDateTime.toDateMidnight()) ? ValueType.TIMEOFDAY : ValueType.DATETIME) : ValueType.DATE;
        switch (1.$SwitchMap$com$google$visualization$datasource$datatable$value$ValueType[dateTimeColumnType.ordinal()]) {
            case 1: {
                dateTimeColumn = new ColumnDescription("time", dateTimeColumnType, "Time");
                break;
            }
            default: {
                dateTimeColumn = new ColumnDescription("date", dateTimeColumnType, "Date");
            }
        }
        JsonDataTable table = new JsonDataTable();
        table.addColumn(dateTimeColumn);
        Set columnGroups = groupedAggregations.keySet();
        for (BaseGroupedAggregationDiscriminator columnMapping : columnGroups) {
            List columnDescriptions = this.getColumnDescriptions(columnMapping, form);
            table.addColumns((Collection)columnDescriptions);
        }
        Set keys = this.createAggregationsQueryKeyset(columnGroups, form);
        BaseAggregationDao baseAggregationDao = this.getBaseAggregationDao();
        List aggregations = baseAggregationDao.getAggregations(startDateTime, endDateTime, keys, this.extractGroupsArray(columnGroups));
        for (BaseAggregation aggregation : aggregations) {
            BaseGroupedAggregationDiscriminator discriminator = aggregation.getAggregationDiscriminator();
            SortedSet results = (SortedSet)groupedAggregations.get(discriminator);
            results.add(aggregation);
        }
        Comparator comparator = this.getDiscriminatorComparator();
        TreeMap groupedAggregationIterators = new TreeMap(comparator);
        for (Map.Entry groupedAggregationEntry : groupedAggregations.entrySet()) {
            groupedAggregationIterators.put(groupedAggregationEntry.getKey(), Iterators.peekingIterator(((SortedSet)groupedAggregationEntry.getValue()).iterator()));
        }
        for (DateTime rowTime : reportTimes) {
            TimeOfDayValue dateTimeValue;
            TableRow row = new TableRow();
            switch (1.$SwitchMap$com$google$visualization$datasource$datatable$value$ValueType[dateTimeColumnType.ordinal()]) {
                case 2: {
                    dateTimeValue = new DateValue(rowTime.getYear(), rowTime.getMonthOfYear() - 1, rowTime.getDayOfMonth());
                    break;
                }
                case 1: {
                    dateTimeValue = new TimeOfDayValue(rowTime.getHourOfDay(), rowTime.getMinuteOfHour(), 0);
                    break;
                }
                default: {
                    dateTimeValue = new DateTimeValue(rowTime.getYear(), rowTime.getMonthOfYear() - 1, rowTime.getDayOfMonth(), rowTime.getHourOfDay(), rowTime.getMinuteOfHour(), 0, 0);
                }
            }
            row.addCell(new TableCell((Value)dateTimeValue));
            for (PeekingIterator groupedAggregationIteratorEntry : groupedAggregationIterators.values()) {
                BaseAggregation aggr;
                List values = null;
                if (groupedAggregationIteratorEntry.hasNext() && rowTime.equals((Object)(aggr = (BaseAggregation)groupedAggregationIteratorEntry.peek()).getDateTime())) {
                    groupedAggregationIteratorEntry.next();
                    values = this.createRowValues(aggr, form);
                }
                if (values == null) {
                    values = this.createRowValues(null, form);
                }
                for (Value value : values) {
                    row.addCell(value);
                }
            }
            table.addRow(row);
        }
        return table;
    }

    private AggregatedGroupMapping[] extractGroupsArray(Set<D> columnGroups) {
        HashSet<AggregatedGroupMapping> groupMappings = new HashSet<AggregatedGroupMapping>();
        for (BaseGroupedAggregationDiscriminator discriminator : columnGroups) {
            groupMappings.add(discriminator.getAggregatedGroup());
        }
        return groupMappings.toArray(new AggregatedGroupMapping[0]);
    }
}

