/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.statistics;

import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.Value;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.BaseAggregationDao;
import org.jasig.portal.events.aggr.BaseAggregationDateTimeComparator;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregation;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationDao;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationDiscriminator;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationDiscriminatorImpl;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationKey;
import org.jasig.portal.events.aggr.portletexec.PortletExecutionAggregationKeyImpl;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletLookupDao;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMapping;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMappingNameComparator;
import org.jasig.portal.portlets.statistics.BaseReportForm;
import org.jasig.portal.portlets.statistics.BaseStatisticsReportController;
import org.jasig.portal.portlets.statistics.PortletExecutionReportForm;
import org.jasig.portal.portlets.statistics.ReportTitleAndColumnDescriptionStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class PortletExecutionStatisticsController
extends BaseStatisticsReportController<PortletExecutionAggregation, PortletExecutionAggregationKey, PortletExecutionAggregationDiscriminator, PortletExecutionReportForm> {
    private static final String DATA_TABLE_RESOURCE_ID = "portletExecutionData";
    private static final String REPORT_NAME = "portletExecution.totals";
    @Autowired
    private ReportTitleAndColumnDescriptionStrategy titleAndColumnDescriptionStrategy;
    @Autowired
    @Qualifier(value="jpaPortletExecutionAggregationDao")
    private PortletExecutionAggregationDao<PortletExecutionAggregation> portletExecutionDao;
    @Autowired
    private AggregatedGroupLookupDao aggregatedGroupLookupDao;
    @Autowired
    private AggregatedPortletLookupDao aggregatedPortletLookupDao;

    public void setTitleAndColumnDescriptionStrategy(ReportTitleAndColumnDescriptionStrategy titleAndColumnDescriptionStrategy) {
        this.titleAndColumnDescriptionStrategy = titleAndColumnDescriptionStrategy;
    }

    @RenderMapping(value="MAXIMIZED", params={"report=portletExecution.totals"})
    public String getLoginView() throws TypeMismatchException {
        return "jsp/Statistics/reportGraph";
    }

    @ResourceMapping(value="portletExecutionData")
    public ModelAndView renderPortletExecutionAggregationReport(PortletExecutionReportForm form) throws TypeMismatchException {
        return this.renderAggregationReport((BaseReportForm)form);
    }

    protected void initReportForm(PortletExecutionReportForm report) {
        this.selectFormDefaultPortlet(report);
        this.selectFormExecutionType(report);
    }

    private void selectFormDefaultPortlet(PortletExecutionReportForm report) {
        if (!report.getPortlets().isEmpty()) {
            return;
        }
        Set portlets = this.getPortlets();
        if (!portlets.isEmpty()) {
            report.getPortlets().add(((AggregatedPortletMapping)portlets.iterator().next()).getFname());
        }
    }

    @ModelAttribute(value="portlets")
    public Set<AggregatedPortletMapping> getPortlets() {
        Set groupMappings = this.aggregatedPortletLookupDao.getPortletMappings();
        TreeSet<AggregatedPortletMapping> sortedGroupMappings = new TreeSet<AggregatedPortletMapping>(AggregatedPortletMappingNameComparator.INSTANCE);
        sortedGroupMappings.addAll(groupMappings);
        return sortedGroupMappings;
    }

    @ModelAttribute(value="executionTypes")
    public PortletExecutionAggregationKey.ExecutionType[] getExecutionTypes() {
        return PortletExecutionAggregationKey.ExecutionType.values();
    }

    private void selectFormExecutionType(PortletExecutionReportForm report) {
        if (!report.getExecutionTypeNames().isEmpty()) {
            return;
        }
        report.getExecutionTypeNames().add(PortletExecutionAggregationKey.ExecutionType.RENDER.name());
    }

    public String getReportName() {
        return REPORT_NAME;
    }

    public String getReportDataResourceId() {
        return DATA_TABLE_RESOURCE_ID;
    }

    protected BaseAggregationDao<PortletExecutionAggregation, PortletExecutionAggregationKey> getBaseAggregationDao() {
        return this.portletExecutionDao;
    }

    protected Set<PortletExecutionAggregationKey> createAggregationsQueryKeyset(Set<PortletExecutionAggregationDiscriminator> columnDiscriminators, PortletExecutionReportForm form) {
        AggregationInterval interval = form.getInterval();
        HashSet<PortletExecutionAggregationKey> keys = new HashSet<PortletExecutionAggregationKey>();
        for (PortletExecutionAggregationDiscriminator discriminator : columnDiscriminators) {
            keys.add((PortletExecutionAggregationKey)new PortletExecutionAggregationKeyImpl(interval, discriminator.getAggregatedGroup(), discriminator.getPortletMapping(), discriminator.getExecutionType()));
        }
        return keys;
    }

    protected Comparator<? super PortletExecutionAggregationDiscriminator> getDiscriminatorComparator() {
        return PortletExecutionAggregationDiscriminatorImpl.Comparator.INSTANCE;
    }

    protected Map<PortletExecutionAggregationDiscriminator, SortedSet<PortletExecutionAggregation>> createColumnDiscriminatorMap(PortletExecutionReportForm form) {
        TreeMap<PortletExecutionAggregationDiscriminator, SortedSet<PortletExecutionAggregation>> groupedAggregations = new TreeMap<PortletExecutionAggregationDiscriminator, SortedSet<PortletExecutionAggregation>>((Comparator<PortletExecutionAggregationDiscriminator>)PortletExecutionAggregationDiscriminatorImpl.Comparator.INSTANCE);
        List groups = form.getGroups();
        Set portletFNames = form.getPortlets();
        Set executionTypes = form.getExecutionTypeNames();
        for (Long queryGroupId : groups) {
            AggregatedGroupMapping groupMapping = this.aggregatedGroupLookupDao.getGroupMapping(queryGroupId.longValue());
            for (String portletFName : portletFNames) {
                AggregatedPortletMapping tabMapping = this.aggregatedPortletLookupDao.getMappedPortletForFname(portletFName);
                for (String executionType : executionTypes) {
                    PortletExecutionAggregationDiscriminatorImpl mapping = new PortletExecutionAggregationDiscriminatorImpl(groupMapping, tabMapping, PortletExecutionAggregationKey.ExecutionType.valueOf((String)executionType));
                    TreeSet aggregations = new TreeSet(BaseAggregationDateTimeComparator.INSTANCE);
                    groupedAggregations.put((PortletExecutionAggregationDiscriminator)mapping, aggregations);
                }
            }
        }
        return groupedAggregations;
    }

    protected String getReportTitleAugmentation(PortletExecutionReportForm form) {
        int groupSize = form.getGroups().size();
        int portletSize = form.getPortlets().size();
        int executionTypeSize = form.getExecutionTypeNames().size();
        String firstPortletName = this.aggregatedPortletLookupDao.getMappedPortletForFname((String)form.getPortlets().iterator().next()).getFname();
        Long firstGroupId = (long)((Long)form.getGroups().iterator().next());
        String firstGroupName = this.aggregatedGroupLookupDao.getGroupMapping(firstGroupId.longValue()).getGroupName();
        String firstExecutionType = (String)form.getExecutionTypeNames().iterator().next();
        ReportTitleAndColumnDescriptionStrategy.TitleAndCount[] items = new ReportTitleAndColumnDescriptionStrategy.TitleAndCount[]{new ReportTitleAndColumnDescriptionStrategy.TitleAndCount(firstPortletName, portletSize), new ReportTitleAndColumnDescriptionStrategy.TitleAndCount(firstExecutionType, executionTypeSize), new ReportTitleAndColumnDescriptionStrategy.TitleAndCount(firstGroupName, groupSize)};
        return this.titleAndColumnDescriptionStrategy.getReportTitleAugmentation(items);
    }

    protected List<ColumnDescription> getColumnDescriptions(PortletExecutionAggregationDiscriminator reportColumnDiscriminator, PortletExecutionReportForm form) {
        int groupSize = form.getGroups().size();
        int portletSize = form.getPortlets().size();
        int executionTypeSize = form.getExecutionTypeNames().size();
        String portletName = reportColumnDiscriminator.getPortletMapping().getFname();
        String groupName = reportColumnDiscriminator.getAggregatedGroup().getGroupName();
        String executionTypeName = reportColumnDiscriminator.getExecutionType().getName();
        ReportTitleAndColumnDescriptionStrategy.TitleAndCount[] items = new ReportTitleAndColumnDescriptionStrategy.TitleAndCount[]{new ReportTitleAndColumnDescriptionStrategy.TitleAndCount(portletName, portletSize), new ReportTitleAndColumnDescriptionStrategy.TitleAndCount(executionTypeName, executionTypeSize), new ReportTitleAndColumnDescriptionStrategy.TitleAndCount(groupName, groupSize)};
        return this.titleAndColumnDescriptionStrategy.getColumnDescriptions(items, this.showFullColumnHeaderDescriptions((BaseReportForm)form), (BaseReportForm)form);
    }

    protected List<Value> createRowValues(PortletExecutionAggregation aggr, PortletExecutionReportForm form) {
        int count = aggr != null ? aggr.getExecutionCount() : 0;
        return Collections.singletonList(new NumberValue((double)count));
    }
}

