/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.character.stream.CharacterEventReader;
import org.jasig.portal.character.stream.events.CharacterEvent;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.PortletRenderExecutionEvent;
import org.jasig.portal.events.RequestScopedEventsTracker;
import org.jasig.portal.events.aggr.tabs.AggregatedTabLookupDao;
import org.jasig.portal.events.aggr.tabs.AggregatedTabMapping;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.rendering.AnalyticsIncorporationComponent;
import org.jasig.portal.rendering.CharacterPipelineComponentWrapper;
import org.jasig.portal.rendering.PipelineEventReader;
import org.jasig.portal.rendering.PipelineEventReaderImpl;
import org.jasig.portal.spring.beans.factory.ObjectMapperFactoryBean;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.utils.cache.CacheKey;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class AnalyticsIncorporationComponent
extends CharacterPipelineComponentWrapper
implements InitializingBean {
    private ObjectMapper mapper;
    private ObjectWriter portletEventWriter;
    private AggregatedTabLookupDao aggregatedTabLookupDao;
    private IUrlSyntaxProvider urlSyntaxProvider;
    private RequestScopedEventsTracker requestScopedEventsTracker;

    public void afterPropertiesSet() throws Exception {
        ObjectMapperFactoryBean omfb = new ObjectMapperFactoryBean();
        omfb.afterPropertiesSet();
        this.mapper = (ObjectMapper)omfb.getObject();
        this.initMapper();
    }

    private void initMapper() {
        SimpleBeanPropertyFilter filterOutAllExcept = SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"fname", "executionTimeNano"});
        this.mapper.addMixInAnnotations(PortalEvent.class, PortletRenderExecutionEventFilterMixIn.class);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("PortletRenderExecutionEventFilter", (BeanPropertyFilter)filterOutAllExcept);
        this.portletEventWriter = this.mapper.writer((FilterProvider)filterProvider);
    }

    @Autowired
    public void setAggregatedTabLookupDao(AggregatedTabLookupDao aggregatedTabLookupDao) {
        this.aggregatedTabLookupDao = aggregatedTabLookupDao;
    }

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    @Autowired
    public void setRequestScopedEventsTracker(RequestScopedEventsTracker requestScopedEventsTracker) {
        this.requestScopedEventsTracker = requestScopedEventsTracker;
    }

    public CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        return this.wrappedComponent.getCacheKey(request, response);
    }

    public PipelineEventReader<CharacterEventReader, CharacterEvent> getEventReader(HttpServletRequest request, HttpServletResponse response) {
        long startTime = System.nanoTime();
        PipelineEventReader pipelineEventReader = this.wrappedComponent.getEventReader(request, response);
        CharacterEventReader eventReader = (CharacterEventReader)pipelineEventReader.getEventReader();
        AnalyticsIncorporatingEventReader portletIncorporatingEventReader = new AnalyticsIncorporatingEventReader(this, eventReader, request, startTime);
        Map outputProperties = pipelineEventReader.getOutputProperties();
        return new PipelineEventReaderImpl((Object)portletIncorporatingEventReader, outputProperties);
    }

    protected String serializePortletRenderExecutionEvents(Set<PortalEvent> portalEvents) {
        HashMap<String, PortletRenderExecutionEvent> renderEvents = new HashMap<String, PortletRenderExecutionEvent>();
        for (PortalEvent portalEvent : portalEvents) {
            PortletRenderExecutionEvent portletRenderEvent;
            if (!(portalEvent instanceof PortletRenderExecutionEvent) || WindowState.MINIMIZED.equals((Object)(portletRenderEvent = (PortletRenderExecutionEvent)portalEvent).getWindowState())) continue;
            IPortletWindowId portletWindowId = portletRenderEvent.getPortletWindowId();
            String eventKey = portletWindowId != null ? portletWindowId.getStringId() : portletRenderEvent.getFname();
            renderEvents.put(eventKey, portletRenderEvent);
        }
        try {
            return this.portletEventWriter.writeValueAsString(renderEvents);
        }
        catch (JsonParseException e) {
            this.logger.warn("Failed to convert this request's render events to JSON, no portlet level analytics will be included", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.warn("Failed to convert this request's render events to JSON, no portlet level analytics will be included", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.warn("Failed to convert this request's render events to JSON, no portlet level analytics will be included", (Throwable)e);
        }
        return "{}";
    }

    protected String serializePageData(HttpServletRequest request, long startTime) {
        HashMap<String, Long> pageData = new HashMap<String, Long>();
        pageData.put("executionTimeNano", System.nanoTime() - startTime);
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        pageData.put("urlState", (Long)portalRequestInfo.getUrlState());
        String targetedLayoutNodeId = portalRequestInfo.getTargetedLayoutNodeId();
        if (targetedLayoutNodeId != null) {
            AggregatedTabMapping mappedTabForLayoutId = this.aggregatedTabLookupDao.getMappedTabForLayoutId(targetedLayoutNodeId);
            pageData.put("tab", (Long)mappedTabForLayoutId);
        }
        try {
            return this.mapper.writeValueAsString(pageData);
        }
        catch (JsonParseException e) {
            this.logger.warn("Failed to convert this request's page data to JSON, no page level analytics will be included", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.warn("Failed to convert this request's page data to JSON, no page level analytics will be included", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.warn("Failed to convert this request's page data to JSON, no page level analytics will be included", (Throwable)e);
        }
        return "{}";
    }

    static /* synthetic */ RequestScopedEventsTracker access$000(AnalyticsIncorporationComponent x0) {
        return x0.requestScopedEventsTracker;
    }
}

