/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering.cache;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.jasig.portal.rendering.PipelineComponentWrapper;
import org.jasig.portal.rendering.PipelineEventReader;
import org.jasig.portal.rendering.PipelineEventReaderImpl;
import org.jasig.portal.rendering.cache.CachedEventReader;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CachingPipelineComponent<R, E>
extends PipelineComponentWrapper<R, E>
implements BeanNameAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ResourcesElementsProvider resourcesElementsProvider;
    private Ehcache cache;
    private String beanName;

    @Autowired
    public void setResourcesElementsProvider(ResourcesElementsProvider resourcesElementsProvider) {
        this.resourcesElementsProvider = resourcesElementsProvider;
    }

    public final void setCache(Ehcache cache) {
        this.cache = cache;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public final CacheKey getCacheKey(HttpServletRequest request, HttpServletResponse response) {
        return this.wrappedComponent.getCacheKey(request, response);
    }

    public final PipelineEventReader<R, E> getEventReader(HttpServletRequest request, HttpServletResponse response) {
        if (Included.PLAIN == this.resourcesElementsProvider.getDefaultIncludedType()) {
            this.logger.trace("{} - Resoure Aggregation Disabled, ignoring event cache and returning parent event reader directly", (Object)this.beanName);
            return this.wrappedComponent.getEventReader(request, response);
        }
        CacheKey cacheKey = this.wrappedComponent.getCacheKey(request, response);
        Element element = this.cache.get((Serializable)cacheKey);
        CachedEventReader cachedEventReader = null;
        if (element != null) {
            cachedEventReader = (CachedEventReader)element.getObjectValue();
        }
        if (cachedEventReader == null) {
            this.logger.debug("{} - No cached events found for key {}, calling parent", (Object)this.beanName, (Object)cacheKey);
            PipelineEventReader pipelineEventReader = this.wrappedComponent.getEventReader(request, response);
            LinkedList eventCache = new LinkedList();
            for (Object event : pipelineEventReader) {
                eventCache.add(event);
            }
            Map outputProperties = pipelineEventReader.getOutputProperties();
            cachedEventReader = new CachedEventReader(eventCache, new LinkedHashMap(outputProperties));
            element = new Element((Serializable)cacheKey, (Serializable)cachedEventReader);
            this.cache.put(element);
            this.logger.debug("{} - Cached {} events for key {}", new Object[]{this.beanName, eventCache.size(), cacheKey});
        } else {
            this.logger.debug("{} - Founed  cached events for key {}", new Object[]{this.beanName, cacheKey});
        }
        List eventCache = cachedEventReader.getEventCache();
        Map outputProperties = cachedEventReader.getOutputProperties();
        Object eventReader = this.createEventReader(eventCache.listIterator());
        return new PipelineEventReaderImpl(eventReader, outputProperties);
    }

    protected abstract R createEventReader(ListIterator<E> var1);
}

