/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering.xslt;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.rendering.xslt.SkinMappingTransformerConfigurationSource;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.beans.factory.annotation.Autowired;

public class UserAttributeSkinMappingTransformerConfigurationSource
extends SkinMappingTransformerConfigurationSource {
    private IUserInstanceManager userInstanceManager;
    private IPersonAttributeDao personAttributeDao;
    private String skinAttributeName = "skinOverride";
    private Map<Pattern, String> attributeToSkinMap = Collections.emptyMap();

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setPersonAttributeDao(IPersonAttributeDao personAttributeDao) {
        this.personAttributeDao = personAttributeDao;
    }

    public void setSkinAttributeName(String skinAttributeName) {
        this.skinAttributeName = skinAttributeName;
    }

    public void setAttributeToSkinMap(Map<Pattern, String> attributeToSkinMap) {
        this.attributeToSkinMap = attributeToSkinMap;
    }

    protected String getSkinName(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IPerson person = userInstance.getPerson();
        IPersonAttributes personAttrs = this.personAttributeDao.getPerson(person.getUserName());
        if (personAttrs == null) {
            this.logger.debug("No user attributes found for {} no skin override will be done", (Object)person.getUserName());
            return null;
        }
        Object attributeValue = personAttrs.getAttributeValue(this.skinAttributeName);
        if (attributeValue == null) {
            this.logger.debug("No user {} does not have attribute {} defined, no skin override will be done", (Object)person.getUserName(), (Object)this.skinAttributeName);
            return null;
        }
        String mappedSkinName = this.getMappedSkinName(attributeValue.toString());
        if (mappedSkinName == null) {
            this.logger.debug("No skin is mapped for attribute {}, no skin override will be done", attributeValue);
            return null;
        }
        this.logger.debug("Overidding skin to {}", (Object)mappedSkinName);
        return mappedSkinName;
    }

    private String getMappedSkinName(String attributeValue) {
        for (Map.Entry attributeMapEntry : this.attributeToSkinMap.entrySet()) {
            Pattern attributePattern = (Pattern)attributeMapEntry.getKey();
            Matcher attributeMatcher = attributePattern.matcher(attributeValue);
            if (!attributeMatcher.matches()) continue;
            return (String)attributeMapEntry.getValue();
        }
        return null;
    }
}

