/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rest;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class RemoteCookieCheckController {
    public static final String COOKIE_CHECK_REQUEST_MAPPING = "/cookiecheck";

    @RequestMapping(value={"/cookiecheck"}, method={RequestMethod.GET})
    public ModelAndView verifyCookiesEnabled(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean cookieFound = false;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equalsIgnoreCase("JSESSIONID")) continue;
                cookieFound = true;
                break;
            }
        }
        if (cookieFound) {
            String referer = (String)request.getSession().getAttribute("COOKIE_CHECK_REFERER");
            response.sendRedirect(referer);
            return null;
        }
        return new ModelAndView("/jsp/PortletError/cookies");
    }
}

