/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rest.permissions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.permission.IPermissionActivity;
import org.jasig.portal.permission.IPermissionOwner;
import org.jasig.portal.permission.dao.IPermissionOwnerDao;
import org.jasig.portal.permission.target.IPermissionTarget;
import org.jasig.portal.permission.target.IPermissionTargetProvider;
import org.jasig.portal.permission.target.IPermissionTargetProviderRegistry;
import org.jasig.portal.portlets.groupselector.EntityEnum;
import org.jasig.portal.rest.permissions.JsonPermission;
import org.jasig.portal.rest.permissions.PermissionsRESTController;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionStore;
import org.jasig.portal.services.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PermissionsRESTController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IPermissionOwnerDao permissionOwnerDao;
    private IPermissionTargetProviderRegistry targetProviderRegistry;
    private IPermissionStore permissionStore;
    private IGroupListHelper groupListHelper;
    private IAuthorizationService authorizationService;

    @Autowired(required=true)
    public void setPermissionOwnerDao(IPermissionOwnerDao permissionOwnerDao) {
        this.permissionOwnerDao = permissionOwnerDao;
    }

    @Autowired(required=true)
    public void setPermissionTargetProviderRegistry(IPermissionTargetProviderRegistry registry) {
        this.targetProviderRegistry = registry;
    }

    @Autowired
    public void setPermissionStore(IPermissionStore permissionStore) {
        this.permissionStore = permissionStore;
    }

    @Autowired
    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    @Autowired
    public void setAuthorizationService(IAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @PreAuthorize(value="hasPermission('string', 'ALL', new org.jasig.portal.spring.security.evaluator.AuthorizableActivity('UP_PERMISSIONS', 'VIEW_PERMISSIONS'))")
    @RequestMapping(value={"/permissions/owners.json"}, method={RequestMethod.GET})
    public ModelAndView getOwners(HttpServletRequest req, HttpServletResponse response) throws Exception {
        List owners = this.permissionOwnerDao.getAllPermissionOwners();
        ModelAndView mv = new ModelAndView();
        mv.addObject("owners", (Object)owners);
        mv.setViewName("json");
        return mv;
    }

    @PreAuthorize(value="hasPermission('string', 'ALL', new org.jasig.portal.spring.security.evaluator.AuthorizableActivity('UP_PERMISSIONS', 'VIEW_PERMISSIONS'))")
    @RequestMapping(value={"/permissions/owners/{owner}.json"}, method={RequestMethod.GET})
    public ModelAndView getOwners(@PathVariable(value="owner") String ownerParam, HttpServletRequest req, HttpServletResponse response) throws Exception {
        IPermissionOwner owner = null;
        if (StringUtils.isNumeric((String)ownerParam)) {
            Long id = Long.valueOf(ownerParam);
            owner = this.permissionOwnerDao.getPermissionOwner(id.longValue());
        } else {
            owner = this.permissionOwnerDao.getPermissionOwner(ownerParam);
        }
        if (owner != null) {
            ModelAndView mv = new ModelAndView();
            mv.addObject("owner", (Object)owner);
            mv.setViewName("json");
            return mv;
        }
        response.setStatus(404);
        return null;
    }

    @PreAuthorize(value="hasPermission('string', 'ALL', new org.jasig.portal.spring.security.evaluator.AuthorizableActivity('UP_PERMISSIONS', 'VIEW_PERMISSIONS'))")
    @RequestMapping(value={"/permissions/activities.json"}, method={RequestMethod.GET})
    public ModelAndView getActivities(@RequestParam(value="q", required=false) String query, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (StringUtils.isNotBlank((String)query)) {
            query = query.toLowerCase();
        }
        ArrayList<IPermissionActivity> activities = new ArrayList<IPermissionActivity>();
        List owners = this.permissionOwnerDao.getAllPermissionOwners();
        for (IPermissionOwner owner : owners) {
            for (IPermissionActivity activity : owner.getActivities()) {
                if (!StringUtils.isBlank((String)query) && !activity.getName().toLowerCase().contains(query)) continue;
                activities.add(activity);
            }
        }
        Collections.sort(activities);
        ModelAndView mv = new ModelAndView();
        mv.addObject("activities", activities);
        mv.setViewName("json");
        return mv;
    }

    @PreAuthorize(value="hasPermission('string', 'ALL', new org.jasig.portal.spring.security.evaluator.AuthorizableActivity('UP_PERMISSIONS', 'VIEW_PERMISSIONS'))")
    @RequestMapping(value={"/permissions/{activity}/targets.json"}, method={RequestMethod.GET})
    public ModelAndView getTargets(@PathVariable(value="activity") Long activityId, @RequestParam(value="q") String query, HttpServletRequest req, HttpServletResponse response) throws Exception {
        IPermissionActivity activity = this.permissionOwnerDao.getPermissionActivity(activityId.longValue());
        IPermissionTargetProvider provider = this.targetProviderRegistry.getTargetProvider(activity.getTargetProviderKey());
        TreeSet matchingTargets = new TreeSet();
        Collection targets = provider.searchTargets(query);
        for (IPermissionTarget target : targets) {
            if ((!StringUtils.isNotBlank((String)target.getName()) || !target.getName().toLowerCase().contains(query)) && !target.getKey().toLowerCase().contains(query)) continue;
            matchingTargets.addAll(targets);
        }
        ModelAndView mv = new ModelAndView();
        mv.addObject("targets", (Object)targets);
        mv.setViewName("json");
        return mv;
    }

    @PreAuthorize(value="hasPermission('string', 'ALL', new org.jasig.portal.spring.security.evaluator.AuthorizableActivity('UP_PERMISSIONS', 'VIEW_PERMISSIONS'))")
    @RequestMapping(value={"/assignments/principal/{principal}.json"})
    public ModelAndView getAssignmentsForPrincipal(@PathVariable(value="principal") String principal, @RequestParam(value="includeInherited", required=false) boolean includeInherited, HttpServletRequest request, HttpServletResponse response) {
        JsonEntityBean entity = this.groupListHelper.getEntityForPrincipal(principal);
        List permissions = this.getPermissionsForEntity(entity, includeInherited);
        ModelAndView mv = new ModelAndView();
        mv.addObject("assignments", (Object)permissions);
        mv.setViewName("json");
        return mv;
    }

    @PreAuthorize(value="(#entityType == 'person' and #id == authentication.name) or hasPermission('string', 'ALL', new org.jasig.portal.spring.security.evaluator.AuthorizableActivity('UP_PERMISSIONS', 'VIEW_PERMISSIONS'))")
    @RequestMapping(value={"/assignments/{entityType}/{id}.json"})
    public ModelAndView getAssignmentsForEntity(@PathVariable(value="entityType") String entityType, @PathVariable(value="id") String id, @RequestParam(value="includeInherited", required=false) boolean includeInherited, HttpServletRequest request, HttpServletResponse response) {
        JsonEntityBean entity = this.groupListHelper.getEntity(entityType, id, false);
        List permissions = this.getPermissionsForEntity(entity, includeInherited);
        ModelAndView mv = new ModelAndView();
        mv.addObject("assignments", (Object)permissions);
        mv.setViewName("json");
        return mv;
    }

    @PreAuthorize(value="hasPermission('string', 'ALL', new org.jasig.portal.spring.security.evaluator.AuthorizableActivity('UP_PERMISSIONS', 'VIEW_PERMISSIONS'))")
    @RequestMapping(value={"/assignments/target/{target}.json"})
    public ModelAndView getAssignmentsOnTarget(@PathVariable(value="target") String target, @RequestParam(value="includeInherited", required=false) boolean includeInherited, HttpServletRequest request, HttpServletResponse response) {
        Class clazz;
        EntityEnum entityType;
        JsonEntityBean e;
        IPermission[] directPermissions;
        HashSet<UniquePermission> directAssignments = new HashSet<UniquePermission>();
        for (IPermission permission : directPermissions = this.permissionStore.select(null, null, null, target, null)) {
            directAssignments.add(new UniquePermission(permission.getOwner(), permission.getActivity(), permission.getPrincipal(), false));
        }
        JsonEntityBean entity = this.groupListHelper.getEntityForPrincipal(target);
        IAuthorizationPrincipal p = this.authorizationService.newPrincipal(entity.getId(), entity.getEntityType().getClazz());
        HashSet<UniquePermission> inheritedAssignments = new HashSet<UniquePermission>();
        if (includeInherited) {
            IGroupMember member = GroupService.getGroupMember((String)p.getKey(), (Class)p.getType());
            Iterator iter = member.getAllContainingGroups();
            while (iter.hasNext()) {
                IPermission[] parentPermissions;
                IEntityGroup parent = (IEntityGroup)iter.next();
                IAuthorizationPrincipal parentPrincipal = this.authorizationService.newPrincipal((IGroupMember)parent);
                for (IPermission permission : parentPermissions = this.permissionStore.select(null, null, null, parentPrincipal.getKey(), null)) {
                    inheritedAssignments.add(new UniquePermission(permission.getOwner(), permission.getActivity(), permission.getPrincipal(), true));
                }
            }
        }
        ArrayList<JsonPermission> permissions = new ArrayList<JsonPermission>();
        for (UniquePermission permission : directAssignments) {
            e = this.groupListHelper.getEntityForPrincipal(permission.getIdentifier());
            entityType = EntityEnum.getEntityEnum((String)e.getEntityTypeAsString());
            clazz = entityType.isGroup() ? IEntityGroup.class : entityType.getClazz();
            IAuthorizationPrincipal principal = this.authorizationService.newPrincipal(e.getId(), clazz);
            if (!principal.hasPermission(permission.getOwner(), permission.getActivity(), p.getKey())) continue;
            permissions.add(this.getPermissionOnTarget(permission, entity));
        }
        for (UniquePermission permission : inheritedAssignments) {
            e = this.groupListHelper.getEntityForPrincipal(permission.getIdentifier());
            entityType = EntityEnum.getEntityEnum((String)e.getEntityTypeAsString());
            clazz = entityType.isGroup() ? IEntityGroup.class : entityType.getClazz();
            IAuthorizationPrincipal principal = this.authorizationService.newPrincipal(e.getId(), clazz);
            if (!principal.hasPermission(permission.getOwner(), permission.getActivity(), p.getKey())) continue;
            permissions.add(this.getPermissionOnTarget(permission, entity));
        }
        Collections.sort(permissions);
        ModelAndView mv = new ModelAndView();
        mv.addObject("assignments", permissions);
        mv.setViewName("json");
        return mv;
    }

    protected List<JsonPermission> getPermissionsForEntity(JsonEntityBean entity, boolean includeInherited) {
        IPermission[] directPermissions;
        HashSet<UniquePermission> directAssignments = new HashSet<UniquePermission>();
        IAuthorizationPrincipal p = this.authorizationService.newPrincipal(entity.getId(), entity.getEntityType().getClazz());
        for (IPermission iPermission : directPermissions = this.permissionStore.select(null, p.getPrincipalString(), null, null, null)) {
            directAssignments.add(new UniquePermission(iPermission.getOwner(), iPermission.getActivity(), iPermission.getTarget(), false));
        }
        HashSet<UniquePermission> inheritedAssignments = new HashSet<UniquePermission>();
        if (includeInherited) {
            IGroupMember member = GroupService.getGroupMember((String)p.getKey(), (Class)p.getType());
            Iterator iter = member.getAllContainingGroups();
            while (iter.hasNext()) {
                IPermission[] parentPermissions;
                IEntityGroup iEntityGroup = (IEntityGroup)iter.next();
                IAuthorizationPrincipal parentPrincipal = this.authorizationService.newPrincipal((IGroupMember)iEntityGroup);
                for (IPermission permission : parentPermissions = this.permissionStore.select(null, parentPrincipal.getPrincipalString(), null, null, null)) {
                    inheritedAssignments.add(new UniquePermission(permission.getOwner(), permission.getActivity(), permission.getTarget(), true));
                }
            }
        }
        ArrayList<JsonPermission> rslt = new ArrayList<JsonPermission>();
        for (UniquePermission uniquePermission : directAssignments) {
            if (!p.hasPermission(uniquePermission.getOwner(), uniquePermission.getActivity(), uniquePermission.getIdentifier())) continue;
            rslt.add(this.getPermissionForPrincipal(uniquePermission, entity));
        }
        for (UniquePermission uniquePermission : inheritedAssignments) {
            if (!p.hasPermission(uniquePermission.getOwner(), uniquePermission.getActivity(), uniquePermission.getIdentifier())) continue;
            rslt.add(this.getPermissionForPrincipal(uniquePermission, entity));
        }
        Collections.sort(rslt);
        return rslt;
    }

    protected JsonPermission getPermissionForPrincipal(UniquePermission permission, JsonEntityBean entity) {
        JsonPermission perm = new JsonPermission();
        perm.setOwnerKey(permission.getOwner());
        perm.setActivityKey(permission.getActivity());
        perm.setTargetKey(permission.getIdentifier());
        perm.setPrincipalKey(entity.getId());
        perm.setPrincipalName(entity.getName());
        perm.setInherited(permission.isInherited());
        try {
            IPermissionActivity activity;
            IPermissionOwner owner = this.permissionOwnerDao.getPermissionOwner(permission.getOwner());
            if (owner != null) {
                perm.setOwnerName(owner.getName());
            }
            if ((activity = this.permissionOwnerDao.getPermissionActivity(permission.getOwner(), permission.getActivity())) != null) {
                IPermissionTarget target;
                perm.setActivityName(activity.getName());
                IPermissionTargetProvider targetProvider = this.targetProviderRegistry.getTargetProvider(activity.getTargetProviderKey());
                if (targetProvider != null && (target = targetProvider.getTarget(permission.getIdentifier())) != null) {
                    perm.setTargetName(target.getName());
                }
            }
        }
        catch (RuntimeException e) {
            this.log.warn((Object)"Exception while adding permission", (Throwable)e);
        }
        return perm;
    }

    protected JsonPermission getPermissionOnTarget(UniquePermission permission, JsonEntityBean entity) {
        JsonPermission perm = new JsonPermission();
        perm.setOwnerKey(permission.getOwner());
        perm.setActivityKey(permission.getActivity());
        perm.setTargetKey(entity.getId());
        perm.setTargetName(entity.getName());
        perm.setInherited(permission.isInherited());
        try {
            IPermissionOwner owner = this.permissionOwnerDao.getPermissionOwner(permission.getOwner());
            if (owner != null) {
                perm.setOwnerName(owner.getName());
            } else {
                perm.setOwnerName(permission.getOwner());
            }
            IPermissionActivity activity = this.permissionOwnerDao.getPermissionActivity(permission.getOwner(), permission.getActivity());
            if (activity != null) {
                perm.setActivityName(activity.getName());
            } else {
                perm.setActivityName(permission.getActivity());
            }
            JsonEntityBean principal = this.groupListHelper.getEntityForPrincipal(permission.getIdentifier());
            if (principal != null) {
                perm.setPrincipalKey(principal.getId());
                perm.setPrincipalName(principal.getName());
            }
        }
        catch (RuntimeException e) {
            this.log.warn((Object)"Exception while adding permission", (Throwable)e);
        }
        return perm;
    }
}

