/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.mvc;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.UrlType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/Login"})
public class LoginController {
    public static final String REFERER_URL_PARAM = "refUrl";
    public static final String AUTH_ATTEMPTED_KEY = "up_authenticationAttempted";
    public static final String AUTH_ERROR_KEY = "up_authenticationError";
    public static final String ATTEMPTED_USERNAME_KEY = "up_attemptedUserName";
    public static final String REQUESTED_PROFILE_KEY = "profile";
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final Log swapperLog = LogFactory.getLog((String)"org.jasig.portal.portlets.swapper");
    private IPortalUrlProvider portalUrlProvider;
    private IPersonManager personManager;

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortalUrlProvider(IPortalUrlProvider portalUrlProvider) {
        this.portalUrlProvider = portalUrlProvider;
    }

    @RequestMapping
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        String redirectTarget = null;
        String refUrl = request.getParameter(REFERER_URL_PARAM);
        if (refUrl != null) {
            if (refUrl.startsWith("/")) {
                redirectTarget = refUrl;
            } else {
                this.log.warn((Object)("Refernce URL passed in does not start with a / and will be ignored: " + refUrl));
            }
        }
        if (redirectTarget == null) {
            String targetFname = request.getParameter("uP_fname");
            if (targetFname == null) {
                IPortalUrlBuilder defaultUrl = this.portalUrlProvider.getDefaultUrl(request);
                redirectTarget = defaultUrl.getUrlString();
            } else {
                try {
                    IPortalUrlBuilder urlBuilder = this.portalUrlProvider.getPortalUrlBuilderByPortletFName(request, targetFname, UrlType.RENDER);
                    Enumeration e = request.getParameterNames();
                    while (e.hasMoreElements()) {
                        String paramName = (String)e.nextElement();
                        if (paramName.equals("uP_fname")) continue;
                        urlBuilder.addParameter(paramName, request.getParameterValues(paramName));
                    }
                    redirectTarget = urlBuilder.getUrlString();
                }
                catch (IllegalArgumentException e) {
                    IPortalUrlBuilder defaultUrl = this.portalUrlProvider.getDefaultUrl(request);
                    redirectTarget = defaultUrl.getUrlString();
                }
            }
        }
        IPerson person = null;
        Object authError = request.getSession(false).getAttribute(AUTH_ERROR_KEY);
        if (authError == null || !((Boolean)authError).booleanValue()) {
            person = this.personManager.getPerson(request);
        }
        if (person == null || !person.getSecurityContext().isAuthenticated()) {
            String attemptedUserName;
            if (request.getMethod().equals("POST")) {
                request.getSession(false).setAttribute(AUTH_ATTEMPTED_KEY, (Object)"true");
            }
            if ((attemptedUserName = request.getParameter("userName")) != null) {
                request.getSession(false).setAttribute(ATTEMPTED_USERNAME_KEY, (Object)request.getParameter("userName"));
            }
        }
        String encodedRedirectURL = response.encodeRedirectURL(redirectTarget);
        response.sendRedirect(encodedRedirectURL);
    }
}

