/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionPolicy;
import org.jasig.portal.services.GroupService;
import org.springframework.stereotype.Service;

@Service(value="anyUnblockedGrantPermissionPolicy")
public class AnyUnblockedGrantPermissionPolicy
implements IPermissionPolicy {
    protected final Log log = LogFactory.getLog(this.getClass());

    public boolean doesPrincipalHavePermission(IAuthorizationService service, IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        boolean hasUnblockedPathToGrant;
        if (service == null || principal == null || owner == null || activity == null) {
            this.log.error((Object)("Null argument to AnyUnblockedGrantPermissionPolicy doesPrincipalHavePermission() method should not be possible.  This is indicative of a potentially serious bug in the permissions and authorization infrastructure. service= [" + service + "] principal = [" + principal + "] owner = [" + owner + "] activity = [" + activity + "] target = [" + target + "]"));
            return false;
        }
        if (!"ALL_PERMISSIONS".equals(activity) && this.doesPrincipalHavePermission(service, principal, "UP_SYSTEM", "ALL_PERMISSIONS", "ALL")) {
            return true;
        }
        IPermission[] perms = service.getPermissionsForPrincipal(principal, owner, activity, target);
        Set activePermissions = this.activePermissions(perms);
        if (this.containsType(activePermissions, "DENY")) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Principal [" + principal + "] is explicitly denied permission to perform activity [" + activity + "] on target [" + target + "] under permission owning system [" + owner + "]."));
            }
            return false;
        }
        if (this.containsType(activePermissions, "GRANT")) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Principal [" + principal + "] is granted permission to perform activity [" + activity + "] on target [" + target + "] under permission owning system [" + owner + "] because this principal has an excplicit GRANT and does not have an exlicit DENY."));
            }
            return true;
        }
        if (target.startsWith("PORTLET_ID.") && this.doesPrincipalHavePermission(service, principal, owner, activity, "ALL_PORTLETS")) {
            return true;
        }
        IEntityGroup targetGroup = GroupService.findGroup((String)target);
        if (targetGroup != null && (targetGroup.getEntityType().equals(IPortletDefinition.class) && this.doesPrincipalHavePermission(service, principal, owner, activity, "ALL_CATEGORIES") || this.doesPrincipalHavePermission(service, principal, owner, activity, "ALL_GROUPS"))) {
            return true;
        }
        try {
            HashSet seenGroups = new HashSet(100);
            hasUnblockedPathToGrant = this.hasUnblockedPathToGrant(service, principal, owner, activity, target, seenGroups);
        }
        catch (Exception e) {
            this.log.error((Object)("Error searching for unblocked path to grant for principal [" + principal + "]"), (Throwable)e);
            return false;
        }
        if (this.log.isTraceEnabled()) {
            if (hasUnblockedPathToGrant) {
                this.log.trace((Object)("Principal [" + principal + "] is granted permission to perform activity [" + activity + "] on target [" + target + "] under permission owning system [" + owner + "] because this principal has an unblocked path to a GRANT."));
            } else {
                this.log.trace((Object)("Principal [" + principal + "] is denied permission to perform activity [" + activity + "] on target [" + target + "] under permission owning system [" + owner + "] because this principal does not have an unblocked path to a GRANT."));
            }
        }
        return hasUnblockedPathToGrant;
    }

    private boolean hasUnblockedPathToGrant(IAuthorizationService service, IAuthorizationPrincipal principal, String owner, String activity, String target, Set<IGroupMember> seenGroups) throws GroupsException {
        IGroupMember principalAsGroupMember;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Searching for unblocked path to GRANT for principal [" + principal + "] to [" + activity + "] on target [" + target + "] having already checked [" + seenGroups + "]"));
        }
        if (seenGroups.contains(principalAsGroupMember = service.getGroupMember(principal))) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Declining to re-examine principal [" + principal + "] for permission to [" + activity + "] on [" + target + "] because this group is among already checked groups [" + seenGroups + "]"));
            }
            return false;
        }
        seenGroups.add(principalAsGroupMember);
        Iterator immediatelyContainingGroups = principalAsGroupMember.getContainingGroups();
        while (immediatelyContainingGroups.hasNext()) {
            IGroupMember parentGroup = (IGroupMember)immediatelyContainingGroups.next();
            try {
                boolean parentHasUnblockedPathToGrant;
                if (parentGroup == null) continue;
                IAuthorizationPrincipal parentPrincipal = service.newPrincipal(parentGroup);
                IPermission[] parentPermissions = service.getPermissionsForPrincipal(parentPrincipal, owner, activity, target);
                Set activeParentPermissions = this.activePermissions(parentPermissions);
                boolean parentPermissionsContainsDeny = this.containsType(activeParentPermissions, "DENY");
                boolean parentPermissionsContainsGrant = this.containsType(activeParentPermissions, "GRANT");
                if (parentPermissionsContainsGrant && !parentPermissionsContainsDeny) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Found unblocked path to this permission set including a GRANT: [" + activeParentPermissions + "]"));
                    }
                    return true;
                }
                if (parentPermissionsContainsDeny || !(parentHasUnblockedPathToGrant = this.hasUnblockedPathToGrant(service, parentPrincipal, owner, activity, target, seenGroups))) continue;
                return true;
            }
            catch (Exception e) {
                this.log.error((Object)("Error evaluating permissions of parent group [" + parentGroup + "]"), (Throwable)e);
            }
        }
        return false;
    }

    private Set<IPermission> activePermissions(IPermission[] perms) {
        Date now = new Date();
        HashSet<IPermission> activePermissions = new HashSet<IPermission>(1);
        for (int i = 0; i < perms.length; ++i) {
            IPermission p = perms[i];
            if (p.getEffective() != null && p.getEffective().after(now) || p.getExpires() != null && !p.getExpires().after(now)) continue;
            activePermissions.add(p);
        }
        return activePermissions;
    }

    private boolean containsType(Set<IPermission> permissions, String soughtType) {
        if (permissions == null) {
            throw new IllegalArgumentException("Cannot check null set for contents.");
        }
        if (soughtType == null) {
            throw new IllegalArgumentException("Cannot search for type null.");
        }
        for (IPermission permission : permissions) {
            if (permission == null || !soughtType.equals(permission.getType())) continue;
            return true;
        }
        return false;
    }
}

