/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.caching.RequestCache;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.PortletCategory;
import org.jasig.portal.portlet.om.PortletLifecycleState;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.security.IPermissionPolicy;
import org.jasig.portal.security.IPermissionSet;
import org.jasig.portal.security.IPermissionStore;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IUpdatingPermissionManager;
import org.jasig.portal.security.provider.AuthorizationPrincipalImpl;
import org.jasig.portal.security.provider.PermissionManagerImpl;
import org.jasig.portal.security.provider.PermissionSetImpl;
import org.jasig.portal.security.provider.UpdatingPermissionManagerImpl;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.spring.locator.PortletCategoryRegistryLocator;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.portal.utils.cache.UsernameTaggedCacheEntryPurger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="authorizationService")
public class AuthorizationImpl
implements IAuthorizationService {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static final String PRINCIPAL_SEPARATOR = ".";
    private IPermissionStore permissionStore;
    private IPermissionPolicy defaultPermissionPolicy;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private Ehcache principalCache;
    private Ehcache entityParentsCache;
    private Ehcache doesPrincipalHavePermissionCache;
    private static final Class<IPermissionSet> PERMISSION_SET_TYPE = IPermissionSet.class;
    private boolean cachePermissions = true;

    @Autowired
    public void setDefaultPermissionPolicy(IPermissionPolicy newDefaultPermissionPolicy) {
        this.defaultPermissionPolicy = newDefaultPermissionPolicy;
    }

    @Autowired
    public void setPermissionStore(IPermissionStore permissionStore) {
        this.permissionStore = permissionStore;
    }

    @Value(value="${org.jasig.portal.security.IAuthorizationService.cachePermissions}")
    public void setCachePermissions(boolean cachePermissions) {
        this.cachePermissions = cachePermissions;
    }

    @Autowired
    public void setPrincipalCache(@Qualifier(value="org.jasig.portal.security.provider.AuthorizationImpl.AUTH_PRINCIPAL_CACHE") Ehcache principalCache) {
        this.principalCache = new SelfPopulatingCache(principalCache, (CacheEntryFactory)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Autowired
    public void setEntityParentsCache(@Qualifier(value="org.jasig.portal.security.provider.AuthorizationImpl.ENTITY_PARENTS_CACHE") Ehcache entityParentsCache) {
        this.entityParentsCache = entityParentsCache;
    }

    @Autowired
    public void setDoesPrincipalHavePermissionCache(@Qualifier(value="org.jasig.portal.security.provider.AuthorizationImpl.PRINCIPAL_HAS_PERMISSION") Ehcache doesPrincipalHavePermissionCache) {
        this.doesPrincipalHavePermissionCache = doesPrincipalHavePermissionCache;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public void addPermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().add(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }

    protected void cacheAdd(IPermissionSet ps) throws AuthorizationException {
        try {
            EntityCachingService.getEntityCachingService().add((IBasicEntity)ps);
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem adding permissions for " + ps + " to cache", (Throwable)ce);
        }
    }

    protected IPermissionSet cacheGet(IAuthorizationPrincipal principal) throws AuthorizationException {
        try {
            return (IPermissionSet)EntityCachingService.getEntityCachingService().get(PERMISSION_SET_TYPE, principal.getPrincipalString());
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem getting permissions for " + principal + " from cache", (Throwable)ce);
        }
    }

    protected void cacheRemove(IAuthorizationPrincipal ap) throws AuthorizationException {
        try {
            EntityCachingService.getEntityCachingService().remove(PERMISSION_SET_TYPE, ap.getPrincipalString());
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem removing permissions for " + ap + " from cache", (Throwable)ce);
        }
    }

    protected void cacheUpdate(IPermissionSet ps) throws AuthorizationException {
        try {
            EntityCachingService.getEntityCachingService().update((IBasicEntity)ps);
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem updating permissions for " + ps + " in cache", (Throwable)ce);
        }
    }

    @RequestCache
    public boolean canPrincipalConfigure(IAuthorizationPrincipal principal, String portletDefinitionId) throws AuthorizationException {
        String owner = "UP_PORTLET_PUBLISH";
        String target = "PORTLET_ID." + portletDefinitionId;
        IPortletDefinition portlet = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
        if (portlet == null) {
            throw new AuthorizationException("Unable to locate portlet " + portletDefinitionId);
        }
        String activity = "PORTLET_MODE_CONFIG";
        return this.doesPrincipalHavePermission(principal, owner, "PORTLET_MODE_CONFIG", target);
    }

    @RequestCache
    public boolean canPrincipalManage(IAuthorizationPrincipal principal, String portletDefinitionId) throws AuthorizationException {
        String owner = "UP_PORTLET_PUBLISH";
        String target = "PORTLET_ID." + portletDefinitionId;
        IPortletDefinition portlet = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
        if (portlet == null) {
            return this.doesPrincipalHavePermission(principal, owner, "MANAGE_APPROVED", target);
        }
        PortletLifecycleState state = portlet.getLifecycleState();
        int order = state.getOrder();
        String activity = "MANAGE_EXPIRED";
        if ((order <= PortletLifecycleState.EXPIRED.getOrder() || portlet.getExpirationDate() != null) && this.doesPrincipalHavePermission(principal, owner, activity, target)) {
            return true;
        }
        activity = "MANAGE";
        if ((order <= PortletLifecycleState.PUBLISHED.getOrder() || portlet.getPublishDate() != null) && this.doesPrincipalHavePermission(principal, owner, activity, target)) {
            return true;
        }
        activity = "MANAGE_APPROVED";
        this.log.debug((Object)("order: " + order + ", approved order: " + PortletLifecycleState.APPROVED.getOrder()));
        if (order <= PortletLifecycleState.APPROVED.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, target)) {
            return true;
        }
        activity = "MANAGE_CREATED";
        return order <= PortletLifecycleState.CREATED.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, target);
    }

    @RequestCache
    public boolean canPrincipalManage(IAuthorizationPrincipal principal, PortletLifecycleState state, String categoryId) throws AuthorizationException {
        String owner = "UP_PORTLET_PUBLISH";
        PortletCategory category = PortletCategoryRegistryLocator.getPortletCategoryRegistry().getPortletCategory(categoryId);
        if (category == null) {
            throw new AuthorizationException("Unable to locate category " + categoryId);
        }
        int order = state.getOrder();
        String activity = "MANAGE_EXPIRED";
        if (order <= PortletLifecycleState.EXPIRED.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, categoryId)) {
            return true;
        }
        activity = "MANAGE";
        if (order <= PortletLifecycleState.PUBLISHED.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, categoryId)) {
            return true;
        }
        activity = "MANAGE_APPROVED";
        if (order <= PortletLifecycleState.APPROVED.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, categoryId)) {
            return true;
        }
        activity = "MANAGE_CREATED";
        return order <= PortletLifecycleState.CREATED.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, categoryId);
    }

    @RequestCache
    public boolean canPrincipalRender(IAuthorizationPrincipal principal, String portletDefinitionId) throws AuthorizationException {
        return this.canPrincipalSubscribe(principal, portletDefinitionId);
    }

    @RequestCache
    public boolean canPrincipalSubscribe(IAuthorizationPrincipal principal, String portletDefinitionId) {
        String permission;
        String owner = "UP_PORTLET_SUBSCRIBE";
        String target = "PORTLET_ID." + portletDefinitionId;
        IPortletDefinition portlet = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
        if (portlet == null) {
            return false;
        }
        PortletLifecycleState state = portlet.getLifecycleState();
        if (state.equals((Object)PortletLifecycleState.PUBLISHED)) {
            permission = "SUBSCRIBE";
        } else if (state.equals((Object)PortletLifecycleState.APPROVED)) {
            permission = "SUBSCRIBE_APPROVED";
        } else if (state.equals((Object)PortletLifecycleState.CREATED)) {
            permission = "SUBSCRIBE_CREATED";
        } else if (state.equals((Object)PortletLifecycleState.EXPIRED)) {
            permission = "SUBSCRIBE_EXPIRED";
        } else {
            throw new AuthorizationException("Unrecognized lifecycle state for channel " + portletDefinitionId);
        }
        return this.doesPrincipalHavePermission(principal, owner, permission, target);
    }

    @RequestCache
    public boolean doesPrincipalHavePermission(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        return this.doesPrincipalHavePermission(principal, owner, activity, target, this.getDefaultPermissionPolicy());
    }

    @RequestCache
    public boolean doesPrincipalHavePermission(IAuthorizationPrincipal principal, String owner, String activity, String target, IPermissionPolicy policy) throws AuthorizationException {
        CacheKey.CacheKeyBuilder cacheKeyBuilder = CacheKey.builder((String)AuthorizationImpl.class.getName());
        String username = principal.getKey();
        if (IPerson.class.equals((Object)principal.getType())) {
            cacheKeyBuilder.addTag(UsernameTaggedCacheEntryPurger.createCacheEntryTag((String)username));
        }
        cacheKeyBuilder.addAll(new Serializable[]{policy.getClass(), username, principal.getType(), owner, activity, target});
        CacheKey key = cacheKeyBuilder.build();
        Element element = this.doesPrincipalHavePermissionCache.get((Serializable)key);
        if (element != null) {
            return (Boolean)element.getValue();
        }
        boolean doesPrincipalHavePermission = policy.doesPrincipalHavePermission((IAuthorizationService)this, principal, owner, activity, target);
        this.doesPrincipalHavePermissionCache.put(new Element((Serializable)key, (Serializable)Boolean.valueOf(doesPrincipalHavePermission)));
        return doesPrincipalHavePermission;
    }

    public IPermission[] getAllPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        IPermission[] perms = this.getPermissionsForPrincipal(principal, owner, activity, target);
        ArrayList<IPermission> al = new ArrayList<IPermission>(Arrays.asList(perms));
        Iterator i = this.getInheritedPrincipals(principal);
        while (i.hasNext()) {
            IAuthorizationPrincipal p = (IAuthorizationPrincipal)i.next();
            perms = this.getPermissionsForPrincipal(p, owner, activity, target);
            al.addAll(Arrays.asList(perms));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("query for all permissions for prcinipal=[" + principal + "], owner=[" + owner + "], activity=[" + activity + "], target=[" + target + "] returned permissions [" + al + "]"));
        }
        return al.toArray(new IPermission[al.size()]);
    }

    public Vector getAuthorizedChannels(IAuthorizationPrincipal principal) throws AuthorizationException {
        return new Vector();
    }

    public IAuthorizationPrincipal[] getAuthorizedPrincipals(String owner, String activity, String target) throws AuthorizationException {
        IPermission[] permissions = this.getPermissionsForOwner(owner, activity, target);
        return this.getPrincipalsFromPermissions(permissions);
    }

    protected IPermissionPolicy getDefaultPermissionPolicy() {
        return this.defaultPermissionPolicy;
    }

    public IGroupMember getGroupMember(IAuthorizationPrincipal principal) throws GroupsException {
        return this.getGroupMemberForPrincipal(principal);
    }

    private IGroupMember getGroupMemberForPrincipal(IAuthorizationPrincipal principal) throws GroupsException {
        IGroupMember gm = GroupService.getGroupMember((String)principal.getKey(), (Class)principal.getType());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AuthorizationImpl.getGroupMemberForPrincipal(): principal [" + principal + "] " + "got group member [" + gm + "]"));
        }
        return gm;
    }

    private Iterator getGroupsForPrincipal(IAuthorizationPrincipal principal) throws GroupsException {
        IGroupMember gm = this.getGroupMemberForPrincipal(principal);
        return gm.getAllContainingGroups();
    }

    private Iterator getInheritedPrincipals(IAuthorizationPrincipal principal) throws AuthorizationException {
        Iterator i = null;
        ArrayList<IAuthorizationPrincipal> al = new ArrayList<IAuthorizationPrincipal>(5);
        try {
            i = this.getGroupsForPrincipal(principal);
        }
        catch (GroupsException ge) {
            throw new AuthorizationException("Could not retrieve Groups for " + principal, (Throwable)ge);
        }
        while (i.hasNext()) {
            IEntityGroup group = (IEntityGroup)i.next();
            IAuthorizationPrincipal p = this.getPrincipalForGroup(group);
            al.add(p);
        }
        return al.iterator();
    }

    public IPermission[] getPermissionsForOwner(String owner, String activity, String target) throws AuthorizationException {
        return this.primRetrievePermissions(owner, null, activity, target);
    }

    @RequestCache
    public IPermission[] getPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        return this.primGetPermissionsForPrincipal(principal, owner, activity, target);
    }

    private IPermissionStore getPermissionStore() {
        return this.permissionStore;
    }

    public IAuthorizationPrincipal getPrincipal(IPermission permission) throws AuthorizationException {
        String principalString = permission.getPrincipal();
        int idx = principalString.indexOf(PRINCIPAL_SEPARATOR);
        Integer typeId = new Integer(principalString.substring(0, idx));
        Class type = EntityTypes.getEntityType((Integer)typeId);
        String key = principalString.substring(idx + 1);
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal getPrincipalForGroup(IEntityGroup group) {
        String key = group.getKey();
        Class type = EntityTypes.GROUP_ENTITY_TYPE;
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal[] getPrincipalsFromPermissions(IPermission[] permissions) throws AuthorizationException {
        HashSet<IAuthorizationPrincipal> principals = new HashSet<IAuthorizationPrincipal>();
        for (int i = 0; i < permissions.length; ++i) {
            IAuthorizationPrincipal principal = this.getPrincipal(permissions[i]);
            principals.add(principal);
        }
        return principals.toArray(new IAuthorizationPrincipal[principals.size()]);
    }

    public String getPrincipalString(IAuthorizationPrincipal principal) {
        return this.getPrincipalString(principal.getType(), principal.getKey());
    }

    private String getPrincipalString(Class pType, String pKey) {
        Integer type = EntityTypes.getEntityTypeID((Class)pType);
        return type + PRINCIPAL_SEPARATOR + pKey;
    }

    public IPermission[] getUncachedPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        String pString = this.getPrincipalString(principal);
        return this.primRetrievePermissions(owner, pString, activity, target);
    }

    public IPermission newPermission(String owner) {
        return this.newPermission(owner, null);
    }

    public IPermission newPermission(String owner, IAuthorizationPrincipal principal) {
        IPermission p = this.getPermissionStore().newInstance(owner);
        if (principal != null) {
            String pString = this.getPrincipalString(principal);
            p.setPrincipal(pString);
        }
        return p;
    }

    public IPermissionManager newPermissionManager(String owner) {
        return new PermissionManagerImpl(owner, this);
    }

    public IAuthorizationPrincipal newPrincipal(String key, Class type) {
        Tuple principalKey = new Tuple((Object)key, (Object)type);
        Element element = this.principalCache.get((Serializable)principalKey);
        return (IAuthorizationPrincipal)element.getObjectValue();
    }

    public IAuthorizationPrincipal newPrincipal(IGroupMember groupMember) throws GroupsException {
        String key = groupMember.getKey();
        Class type = groupMember.getType();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AuthorizationImpl.newPrincipal(): for " + type + "(" + key + ")"));
        }
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal primNewPrincipal(String key, Class type) {
        return new AuthorizationPrincipalImpl(key, type, (IAuthorizationService)this);
    }

    public IUpdatingPermissionManager newUpdatingPermissionManager(String owner) {
        return new UpdatingPermissionManagerImpl(owner, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPermission[] primGetPermissionsForPrincipal(IAuthorizationPrincipal principal) throws AuthorizationException {
        if (!this.cachePermissions) {
            return this.getUncachedPermissionsForPrincipal(principal, null, null, null);
        }
        IPermissionSet ps = null;
        ps = this.cacheGet(principal);
        if (ps == null) {
            IAuthorizationPrincipal iAuthorizationPrincipal = principal;
            synchronized (iAuthorizationPrincipal) {
                ps = this.cacheGet(principal);
                if (ps == null) {
                    IPermission[] permissions = this.getUncachedPermissionsForPrincipal(principal, null, null, null);
                    ps = new PermissionSetImpl(permissions, principal);
                    this.cacheAdd(ps);
                }
            }
        }
        return ps.getPermissions();
    }

    private IPermission[] primGetPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        Set<String> containingGroups;
        IPermission[] perms = this.primGetPermissionsForPrincipal(principal);
        if (owner == null && activity == null && target == null) {
            return perms;
        }
        if (target != null) {
            Element element = this.entityParentsCache.get((Serializable)((Object)target));
            if (element != null) {
                containingGroups = (Set)element.getObjectValue();
            } else {
                containingGroups = new HashSet();
                if (!("ALL_CATEGORIES".equals(target) || "ALL_GROUPS".equals(target) || "ALL_PORTLETS".equals(target) || "ALL".equals(target))) {
                    IEntityGroup targetEntity = GroupService.findGroup((String)target);
                    if (targetEntity == null) {
                        targetEntity = target.startsWith("PORTLET_ID.") ? GroupService.getGroupMember((String)target.replace("PORTLET_ID.", ""), IPortletDefinition.class) : GroupService.getGroupMember((String)target, IPerson.class);
                    }
                    if (targetEntity != null) {
                        Iterator containing = targetEntity.getAllContainingGroups();
                        while (containing.hasNext()) {
                            containingGroups.add(((IEntityGroup)containing.next()).getKey());
                        }
                    }
                }
                this.entityParentsCache.put(new Element((Object)target, containingGroups));
            }
        } else {
            containingGroups = new HashSet();
        }
        ArrayList<IPermission> al = new ArrayList<IPermission>(perms.length);
        for (int i = 0; i < perms.length; ++i) {
            String permissionTarget = perms[i].getTarget();
            if (owner != null && !owner.equals(perms[i].getOwner()) || activity != null && !activity.equals(perms[i].getActivity()) || target != null && !target.equals(permissionTarget) && !containingGroups.contains(permissionTarget)) continue;
            al.add(perms[i]);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("AuthorizationImpl.primGetPermissionsForPrincipal(): Principal: " + principal + " owner: " + owner + " activity: " + activity + " target: " + target + " : permissions retrieved: " + al));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AuthorizationImpl.primGetPermissionsForPrincipal(): Principal: " + principal + " owner: " + owner + " activity: " + activity + " target: " + target + " : number of permissions retrieved: " + al.size()));
        }
        return al.toArray(new IPermission[al.size()]);
    }

    private IPermission[] primRetrievePermissions(String owner, String principal, String activity, String target) throws AuthorizationException {
        return this.getPermissionStore().select(owner, principal, activity, target, null);
    }

    private void removeFromPermissionsCache(IAuthorizationPrincipal[] principals) throws AuthorizationException {
        for (int i = 0; i < principals.length; ++i) {
            this.cacheRemove(principals[i]);
        }
    }

    private void removeFromPermissionsCache(IPermission[] permissions) throws AuthorizationException {
        IAuthorizationPrincipal[] principals = this.getPrincipalsFromPermissions(permissions);
        this.removeFromPermissionsCache(principals);
    }

    public void removePermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().delete(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }

    public void updatePermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().update(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }

    static /* synthetic */ IAuthorizationPrincipal access$000(AuthorizationImpl x0, String x1, Class x2) {
        return x0.primNewPrincipal(x1, x2);
    }
}

