/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.Date;
import java.util.Iterator;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionPolicy;

public class DefaultPermissionPolicy
implements IPermissionPolicy {
    public boolean doesPrincipalHavePermission(IAuthorizationService service, IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        IPermission[] perms = service.getPermissionsForPrincipal(principal, owner, activity, target);
        if (perms.length == 1) {
            return this.permissionIsGranted(perms[0]);
        }
        if (perms.length > 1) {
            throw new AuthorizationException("Duplicate permissions for: " + perms[0]);
        }
        boolean hasPermission = false;
        try {
            Iterator i = service.getGroupMember(principal).getAllContainingGroups();
            while (i.hasNext() && !hasPermission) {
                IAuthorizationPrincipal prn = service.newPrincipal((IGroupMember)i.next());
                hasPermission = this.primDoesPrincipalHavePermission(prn, owner, activity, target, service);
            }
        }
        catch (GroupsException ge) {
            throw new AuthorizationException((Throwable)ge);
        }
        return hasPermission;
    }

    private boolean permissionIsGranted(IPermission p) {
        Date now = new Date();
        return !(!p.getType().equals("GRANT") || p.getEffective() != null && p.getEffective().after(now) || p.getExpires() != null && !p.getExpires().after(now));
    }

    private boolean primDoesPrincipalHavePermission(IAuthorizationPrincipal principal, String owner, String activity, String target, IAuthorizationService service) throws AuthorizationException {
        IPermission[] perms = service.getPermissionsForPrincipal(principal, owner, activity, target);
        if (perms.length == 0) {
            return false;
        }
        if (perms.length == 1) {
            return this.permissionIsGranted(perms[0]);
        }
        throw new AuthorizationException("Duplicate permissions for: " + perms[0]);
    }
}

