/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.AbstractPersonManager;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.merger.IAttributeMerger;
import org.jasig.services.persondir.support.merger.MultivaluedAttributeMerger;

public class ExtendedPersonManager
extends AbstractPersonManager {
    private static final Log log = LogFactory.getLog(ExtendedPersonManager.class);
    protected IAttributeMerger merger = new MultivaluedAttributeMerger();
    private IPersonAttributes descriptors;

    public IPerson getPerson(HttpServletRequest request) throws PortalSecurityException {
        HttpSession session = request.getSession(false);
        IPerson person = null;
        if (session != null) {
            person = (IPerson)session.getAttribute("org.jasig.portal.security.IPerson");
        }
        if (person == null) {
            try {
                person = PersonFactory.createGuestPerson();
                this.merger.mergeAttributes(person.getAttributeMap(), this.descriptors.getAttributes());
            }
            catch (Exception e) {
                log.error((Object)"Exception creating guest person.", (Throwable)e);
            }
            if (person != null && session != null) {
                session.setAttribute("org.jasig.portal.security.IPerson", (Object)person);
            }
        }
        return person;
    }

    public IAttributeMerger getMerger() {
        return this.merger;
    }

    public void setMerger(IAttributeMerger merger) {
        this.merger = merger;
    }

    public IPersonAttributes getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(IPersonAttributes descriptors) {
        this.descriptors = descriptors;
    }
}

