/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ldap.ILdapServer;
import org.jasig.portal.ldap.LdapServices;
import org.jasig.portal.security.IConfigurableSecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.ChainingSecurityContext;

public class SimpleLdapSecurityContext
extends ChainingSecurityContext
implements IConfigurableSecurityContext {
    private static final Log log = LogFactory.getLog(SimpleLdapSecurityContext.class);
    public static final int ATTR_UID = 0;
    public static final int ATTR_FIRSTNAME = 1;
    public static final int ATTR_LASTNAME = 2;
    private final int SIMPLE_LDAP_SECURITYAUTHTYPE = 65284;
    private static final String[] attributes = new String[]{"uid", "givenName", "sn"};
    public static final String LDAP_PROPERTIES_CONNECTION_NAME = "connection";
    private Properties ctxProperties = new Properties();

    SimpleLdapSecurityContext() {
    }

    public void setProperties(Properties props) {
        this.ctxProperties = props;
    }

    public int getAuthType() {
        this.getClass();
        return 65284;
    }

    public synchronized void authenticate() throws PortalSecurityException {
        block17: {
            this.isauth = false;
            String propFile = this.ctxProperties.getProperty(LDAP_PROPERTIES_CONNECTION_NAME);
            ILdapServer ldapConn = propFile != null && propFile.length() > 0 ? LdapServices.getLdapServer((String)propFile) : LdapServices.getDefaultLdapServer();
            String creds = new String(this.myOpaqueCredentials.credentialstring);
            if (this.myPrincipal.UID != null && !this.myPrincipal.UID.trim().equals("") && this.myOpaqueCredentials.credentialstring != null && !creds.trim().equals("")) {
                DirContext conn = null;
                NamingEnumeration<SearchResult> results = null;
                StringBuffer user = new StringBuffer("(");
                String first_name = null;
                String last_name = null;
                user.append(ldapConn.getUidAttribute()).append("=");
                user.append(this.myPrincipal.UID).append(")");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SimpleLdapSecurityContext: Looking for " + user.toString()));
                }
                try {
                    conn = ldapConn.getConnection();
                    SearchControls searchCtls = new SearchControls();
                    searchCtls.setReturningAttributes(attributes);
                    searchCtls.setSearchScope(2);
                    if (conn != null) {
                        try {
                            results = conn.search(ldapConn.getBaseDN(), user.toString(), searchCtls);
                            if (results != null) {
                                if (!results.hasMore()) {
                                    log.error((Object)("SimpleLdapSecurityContext: user not found , " + this.myPrincipal.UID));
                                }
                                while (results != null && results.hasMore()) {
                                    SearchResult entry = results.next();
                                    StringBuffer dnBuffer = new StringBuffer();
                                    dnBuffer.append(entry.getName()).append(", ");
                                    dnBuffer.append(ldapConn.getBaseDN());
                                    Attributes attrs = entry.getAttributes();
                                    first_name = this.getAttributeValue(attrs, 1);
                                    last_name = this.getAttributeValue(attrs, 2);
                                    conn.removeFromEnvironment("java.naming.security.principal");
                                    conn.removeFromEnvironment("java.naming.security.credentials");
                                    conn.addToEnvironment("java.naming.security.principal", dnBuffer.toString());
                                    conn.addToEnvironment("java.naming.security.credentials", this.myOpaqueCredentials.credentialstring);
                                    searchCtls = new SearchControls();
                                    searchCtls.setReturningAttributes(new String[0]);
                                    searchCtls.setSearchScope(0);
                                    String attrSearch = "(" + ldapConn.getUidAttribute() + "=*)";
                                    log.debug((Object)("SimpleLdapSecurityContext: Looking in " + dnBuffer.toString() + " for " + attrSearch));
                                    conn.search(dnBuffer.toString(), attrSearch, searchCtls);
                                    this.isauth = true;
                                    this.myPrincipal.FullName = first_name + " " + last_name;
                                    log.debug((Object)("SimpleLdapSecurityContext: User " + this.myPrincipal.UID + " (" + this.myPrincipal.FullName + ") is authenticated"));
                                    this.myPrincipal.UID = this.myPrincipal.UID.toLowerCase();
                                }
                            } else {
                                log.error((Object)("SimpleLdapSecurityContext: No such user: " + this.myPrincipal.UID));
                            }
                            break block17;
                        }
                        catch (AuthenticationException ae) {
                            log.info((Object)("SimpleLdapSecurityContext: Password invalid for user: " + this.myPrincipal.UID));
                            break block17;
                        }
                        catch (Exception e) {
                            log.error((Object)("SimpleLdapSecurityContext: LDAP Error with user: " + this.myPrincipal.UID + "; "), (Throwable)e);
                            throw new PortalSecurityException("SimpleLdapSecurityContext: LDAP Error" + e + " with user: " + this.myPrincipal.UID);
                        }
                        finally {
                            ldapConn.releaseConnection(conn);
                        }
                    }
                    log.error((Object)"LDAP Server Connection unavalable");
                }
                catch (NamingException ne) {
                    log.error((Object)"Error geting connection to LDAP server.", (Throwable)ne);
                }
            } else {
                log.error((Object)"Principal or OpaqueCredentials not initialized prior to authenticate");
            }
        }
        super.authenticate();
    }

    private String getAttributeValue(Attributes attrs, int attribute) throws NamingException {
        NamingEnumeration<?> values = null;
        String aValue = "";
        if (!this.isAttribute(attribute)) {
            return aValue;
        }
        Attribute attrib = attrs.get(attributes[attribute]);
        if (attrib != null && (values = attrib.getAll()).hasMoreElements()) {
            aValue = (String)values.nextElement();
        }
        return aValue;
    }

    private boolean isAttribute(int attribute) {
        return attribute >= 0 && attribute <= 2;
    }
}

