/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.remoting;

import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.ISecurityContext;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPermissionsController {
    private static final String PERMISSIONS_ADMIN_PORTLET_FNAME = "permissionsmanager";
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPersonManager personManager;
    private IAuthorizationService authorizationService;

    @Autowired
    public void setAuthorizationService(IAuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    protected final boolean isAuthorized(HttpServletRequest req) throws Exception {
        ISecurityContext securityContext;
        IPerson person = this.personManager.getPerson(req);
        if (person != null && (securityContext = person.getSecurityContext()) != null && securityContext.isAuthenticated()) {
            IAuthorizationPrincipal principal = this.authorizationService.newPrincipal((String)person.getAttribute("username"), IPerson.class);
            IPortletDefinition permissionsAdminPortlet = this.portletDefinitionRegistry.getPortletDefinitionByFname(PERMISSIONS_ADMIN_PORTLET_FNAME);
            if (permissionsAdminPortlet == null) {
                return false;
            }
            String portletId = permissionsAdminPortlet.getPortletDefinitionId().getStringId();
            if (this.authorizationService.canPrincipalSubscribe(principal, portletId)) {
                return true;
            }
        }
        return false;
    }
}

