/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.xslt;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.xslt.IXalanAuthorizationHelper;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XalanAuthorizationHelperBean
implements IXalanAuthorizationHelper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;
    private IPersonManager personManager;

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired(required=true)
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    public boolean canRender(String userName, String fname) {
        String portletId;
        if (userName == null || fname == null) {
            return false;
        }
        IAuthorizationPrincipal userPrincipal = this.getUserPrincipal(userName);
        if (userPrincipal == null) {
            return false;
        }
        try {
            IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinitionByFname(fname);
            if (portletDefinition == null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("No PortletDefinition for fname='" + fname + "', returning false."));
                }
                return false;
            }
            portletId = portletDefinition.getPortletDefinitionId().getStringId();
        }
        catch (Exception e) {
            this.logger.warn((Object)("Could not find PortletDefinition for fname='" + fname + "' while checking if user '" + userName + "' can render it. Returning FALSE."), (Throwable)e);
            return false;
        }
        return userPrincipal.canRender(portletId);
    }

    public boolean hasPermission(String owner, String activity, String target) {
        if (owner == null || activity == null) {
            return false;
        }
        HttpServletRequest currentRequest = this.portalRequestUtils.getCurrentPortalRequest();
        IPerson currentUser = this.personManager.getPerson(currentRequest);
        IAuthorizationPrincipal authPrincipal = this.getUserPrincipal(currentUser.getUserName());
        boolean rslt = authPrincipal != null ? authPrincipal.hasPermission(owner, activity, target) : false;
        return rslt;
    }

    protected IAuthorizationPrincipal getUserPrincipal(String userName) {
        IEntity user = GroupService.getEntity((String)userName, IPerson.class);
        if (user == null) {
            return null;
        }
        AuthorizationService authService = AuthorizationService.instance();
        return authService.newPrincipal((IGroupMember)user);
    }
}

