/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.xslt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.xslt.IXalanGroupMembershipHelper;
import org.jasig.portal.services.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XalanGroupMembershipHelperBean
implements IXalanGroupMembershipHelper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortletDefinitionRegistry portletDefinitionRegistry;

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public boolean isChannelDeepMemberOf(String fname, String groupKey) {
        IPortletDefinition portletDefinition;
        IEntityGroup distinguishedGroup = GroupService.findGroup((String)groupKey);
        if (distinguishedGroup == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No group found for key '" + groupKey + "'"));
            }
            return false;
        }
        try {
            portletDefinition = this.portletDefinitionRegistry.getPortletDefinitionByFname(fname);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Caught exception while retrieving portlet definition for fname '" + fname + "'"), (Throwable)e);
            return false;
        }
        if (portletDefinition == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No portlet found for key '" + fname + "'"));
            }
            return false;
        }
        String portletId = portletDefinition.getPortletDefinitionId().getStringId();
        IEntity entity = GroupService.getEntity((String)portletId, IPortletDefinition.class);
        if (entity == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No portlet found for id '" + portletId + "'"));
            }
            return false;
        }
        return distinguishedGroup.deepContains((IGroupMember)entity);
    }

    public boolean isUserDeepMemberOf(String userName, String groupKey) {
        IEntityGroup distinguishedGroup = GroupService.findGroup((String)groupKey);
        if (distinguishedGroup == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No group found for key '" + groupKey + "'"));
            }
            return false;
        }
        IEntity entity = GroupService.getEntity((String)userName, IPerson.class);
        if (entity == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No user found for key '" + userName + "'"));
            }
            return false;
        }
        return distinguishedGroup.deepContains((IGroupMember)entity);
    }

    public boolean isUserDeepMemberOfGroupName(String userName, String groupName) {
        EntityIdentifier[] results = GroupService.searchForGroups((String)groupName, (int)1, IPerson.class);
        if (results == null || results.length == 0) {
            return false;
        }
        if (results.length > 1) {
            this.logger.warn((Object)(results.length + " groups were found for '" + groupName + "'. The first result will be used."));
        }
        IGroupMember group = GroupService.getGroupMember((EntityIdentifier)results[0]);
        IEntity entity = GroupService.getEntity((String)userName, IPerson.class);
        if (entity == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No user found for key '" + userName + "'"));
            }
            return false;
        }
        return group.deepContains((IGroupMember)entity);
    }
}

