/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services.entityproperties;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.services.EntityPropertyRegistry;
import org.jasig.portal.services.entityproperties.EntityProperties;
import org.jasig.portal.services.entityproperties.IEntityPropertyStore;

/*
 * Exception performing whole class analysis ignored.
 */
public class RDBMPropertyStore
implements IEntityPropertyStore {
    private static final Log log = LogFactory.getLog(RDBMPropertyStore.class);
    protected static Class propsType = null;
    protected static final String TABLE_NAME = "UP_ENTITY_PROP";
    protected static final String TYPE_COL = "ENTITY_TYPE_ID";
    protected static final String KEY_COL = "ENTITY_KEY";
    protected static final String NAME_COL = "PROPERTY_NAME";
    protected static final String VALUE_COL = "PROPERTY_VALUE";
    protected static final String DATE_COL = "LAST_MODIFIED";
    protected static final String selectProperties = "SELECT PROPERTY_NAME, PROPERTY_VALUE FROM UP_ENTITY_PROP WHERE ENTITY_TYPE_ID=? AND ENTITY_KEY=?";
    protected static final String deleteProperty = "DELETE FROM UP_ENTITY_PROP WHERE ENTITY_TYPE_ID=? AND ENTITY_KEY=? AND PROPERTY_NAME=?";
    protected static final String insertProperty = "INSERT INTO UP_ENTITY_PROP VALUES (?,?,?,?,?)";

    public RDBMPropertyStore() {
        try {
            if (propsType == null) {
                propsType = Class.forName("org.jasig.portal.services.entityproperties.EntityProperties");
            }
        }
        catch (Exception e) {
            log.error((Object)"RDBMPropertyStore.Constructor Unable to create propstype", (Throwable)e);
        }
    }

    public String[] getPropertyNames(EntityIdentifier entityID) {
        String[] propNames = null;
        EntityProperties ep = this.getCachedProperties(entityID);
        if (ep != null) {
            propNames = ep.getPropertyNames();
        }
        return propNames;
    }

    public String getProperty(EntityIdentifier entityID, String name) {
        String propVal = null;
        EntityProperties ep = this.getCachedProperties(entityID);
        if (ep != null) {
            propVal = ep.getProperty(name);
        }
        return propVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeProperty(EntityIdentifier entityID, String name, String value) {
        this.unStoreProperty(entityID, name);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement("INSERT INTO UP_ENTITY_PROP VALUES (?,?,?,?,?)");
            try {
                ps.clearParameters();
                ps.setInt(1, EntityTypes.getEntityTypeID((Class)entityID.getType()));
                ps.setString(2, entityID.getKey());
                ps.setString(3, name);
                ps.setString(4, value);
                ps.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                ps.executeUpdate();
            }
            finally {
                RDBMPropertyStore.close((Statement)ps);
            }
            this.clearCache(entityID);
        }
        catch (Exception e) {
            log.error((Object)("RDBMPropertyStore.storeProperty " + ps), (Throwable)e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unStoreProperty(EntityIdentifier entityID, String name) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement("DELETE FROM UP_ENTITY_PROP WHERE ENTITY_TYPE_ID=? AND ENTITY_KEY=? AND PROPERTY_NAME=?");
            try {
                ps.clearParameters();
                ps.setInt(1, EntityTypes.getEntityTypeID((Class)entityID.getType()));
                ps.setString(2, entityID.getKey());
                ps.setString(3, name);
                ps.executeUpdate();
            }
            finally {
                RDBMPropertyStore.close((Statement)ps);
            }
            this.clearCache(entityID);
        }
        catch (Exception e) {
            log.error((Object)("RDBMPropertyStore.unStoreProperty " + ps), (Throwable)e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    protected Connection getConnection() {
        return RDBMServices.getConnection();
    }

    protected void releaseConnection(Connection conn) {
        RDBMServices.releaseConnection((Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityProperties getCachedProperties(EntityIdentifier entityID) {
        EntityProperties ep = EntityPropertyRegistry.instance().getCachedProperties(entityID);
        if (ep == null) {
            ep = new EntityProperties(entityID.getKey());
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                conn = this.getConnection();
                ps = conn.prepareStatement("SELECT PROPERTY_NAME, PROPERTY_VALUE FROM UP_ENTITY_PROP WHERE ENTITY_TYPE_ID=? AND ENTITY_KEY=?");
                try {
                    ps.clearParameters();
                    ps.setInt(1, EntityTypes.getEntityTypeID((Class)entityID.getType()));
                    ps.setString(2, entityID.getKey());
                    ResultSet rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            ep.setProperty(rs.getString("PROPERTY_NAME"), rs.getString("PROPERTY_VALUE"));
                        }
                        this.addToCache(ep);
                    }
                    finally {
                        RDBMPropertyStore.close((ResultSet)rs);
                    }
                }
                finally {
                    RDBMPropertyStore.close((Statement)ps);
                }
            }
            catch (Exception e) {
                log.error((Object)("RDBMPropertyStore.getCachedProperties: " + ps), (Throwable)e);
            }
            finally {
                this.releaseConnection(conn);
            }
        }
        return ep;
    }

    protected void clearCache(EntityIdentifier entityID) {
        EntityPropertyRegistry.instance().clearCache(entityID);
    }

    protected void addToCache(EntityProperties ep) {
        EntityPropertyRegistry.instance().addToCache(ep);
    }

    private static final void close(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException e) {
            log.warn((Object)"problem closing statement", (Throwable)e);
        }
    }

    private static final void close(ResultSet resultset) {
        try {
            resultset.close();
        }
        catch (SQLException e) {
            log.warn((Object)"problem closing resultset", (Throwable)e);
        }
    }
}

