/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.shell;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.io.xml.IPortalDataHandlerService;
import org.jasig.portal.io.xml.PortalDataHandlerServiceUtils;
import org.jasig.portal.jpa.VersionedDataUpdater;
import org.jasig.portal.shell.PortalShell;
import org.jasig.portal.shell.PortalShellBuildHelper;
import org.jasig.portal.tools.DbTest;
import org.jasig.portal.tools.dbloader.DbLoaderConfig;
import org.jasig.portal.tools.dbloader.DbLoaderConfigBuilder;
import org.jasig.portal.tools.dbloader.IDbLoader;
import org.jasig.portal.tools.dbloader.ISchemaExport;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service(value="portalShellBuildHelper")
public class PortalShellBuildHelperImpl
implements PortalShellBuildHelper {
    private static final Pattern COMMA_DELIM = Pattern.compile(",");
    private IDbLoader dbLoader;
    private Map<String, ISchemaExport> schemaExportBeans;
    private IPortalDataHandlerService portalDataHandlerService;
    private IUserIdentityStore userIdentityStore;
    private DbTest dbTest;
    private VersionedDataUpdater versionedDataUpdater;

    @Autowired
    public void setVersionedDataUpdater(VersionedDataUpdater versionedDataUpdater) {
        this.versionedDataUpdater = versionedDataUpdater;
    }

    @Autowired
    public void setDbLoader(IDbLoader dbLoader) {
        this.dbLoader = dbLoader;
    }

    @Autowired
    public void setSchemaExportBeans(Map<String, ISchemaExport> schemaExportBeans) {
        this.schemaExportBeans = schemaExportBeans;
    }

    @Autowired
    public void setPortalDataHandlerService(IPortalDataHandlerService portalDataHandlerService) {
        this.portalDataHandlerService = portalDataHandlerService;
    }

    @Autowired
    public void setUserIdentityStore(IUserIdentityStore userIdentityStore) {
        this.userIdentityStore = userIdentityStore;
    }

    @Autowired
    public void setDbTest(DbTest dbTest) {
        this.dbTest = dbTest;
    }

    public void dbTest() {
        this.dbTest.printDbInfo();
    }

    public void db(String target, String tablesFile, String dataFile, String scriptFile, boolean dropTables, boolean createTables, boolean populateTables) {
        try {
            PortalShell.LOGGER.info("");
            PortalShell.LOGGER.info("");
            DbLoaderConfigBuilder dbLoaderConfig = new DbLoaderConfigBuilder();
            dbLoaderConfig.setTablesFile(tablesFile);
            dbLoaderConfig.setDataFile(dataFile);
            if (StringUtils.isNotBlank((String)scriptFile)) {
                dbLoaderConfig.setScriptFile(scriptFile);
            }
            dbLoaderConfig.setDropTables(dropTables);
            dbLoaderConfig.setCreateTables(createTables);
            dbLoaderConfig.setPopulateTables(populateTables);
            PortalShell.LOGGER.info("Running DbLoader with: " + dbLoaderConfig);
            this.dbLoader.process((DbLoaderConfig)dbLoaderConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(target + " for " + tablesFile + " and " + dataFile + " failed", e);
        }
    }

    public void hibernateCreate(String target, String databaseQualifier, boolean export, String outputFile) {
        ISchemaExport schemaExportBean = this.getSchemaExport(databaseQualifier);
        if (schemaExportBean == null) {
            throw new RuntimeException(target + " could not find schemaExportBean " + databaseQualifier);
        }
        try {
            PortalShell.LOGGER.info("");
            PortalShell.LOGGER.info("");
            PortalShell.LOGGER.info("Hibernate Create DDL: " + databaseQualifier);
            outputFile = StringUtils.trimToNull((String)outputFile);
            schemaExportBean.create(export, outputFile, true);
            this.versionedDataUpdater.postInitDatabase(databaseQualifier);
        }
        catch (Exception e) {
            throw new RuntimeException(target + " for " + databaseQualifier + " failed", e);
        }
    }

    public void hibernateDrop(String target, String databaseQualifier, boolean export, String outputFile) {
        ISchemaExport schemaExportBean = this.getSchemaExport(databaseQualifier);
        if (schemaExportBean == null) {
            throw new RuntimeException(target + " could not find schemaExportBean " + databaseQualifier);
        }
        try {
            PortalShell.LOGGER.info("");
            PortalShell.LOGGER.info("");
            PortalShell.LOGGER.info("Hibernate Drop DDL: " + databaseQualifier);
            outputFile = StringUtils.trimToNull((String)outputFile);
            schemaExportBean.drop(export, outputFile, true);
        }
        catch (Exception e) {
            throw new RuntimeException(target + " for " + databaseQualifier + " failed", e);
        }
    }

    public void hibernateUpdate(String target, String databaseQualifier, boolean export, String outputFile) {
        this.versionedDataUpdater.preUpdateDatabase(databaseQualifier);
        ISchemaExport schemaExportBean = this.getSchemaExport(databaseQualifier);
        if (schemaExportBean == null) {
            throw new RuntimeException(target + " could not find schemaExportBean " + databaseQualifier);
        }
        try {
            PortalShell.LOGGER.info("");
            PortalShell.LOGGER.info("");
            PortalShell.LOGGER.info("Hibernate Update DDL: " + databaseQualifier);
            outputFile = StringUtils.trimToNull((String)outputFile);
            schemaExportBean.update(export, outputFile, true);
        }
        catch (Exception e) {
            throw new RuntimeException(target + " for " + databaseQualifier + " failed", e);
        }
        this.versionedDataUpdater.postUpdateDatabase(databaseQualifier);
    }

    public void dataList(String target, String type) {
        try {
            if (StringUtils.isBlank((String)type)) {
                PortalShell.LOGGER.info("");
                PortalShell.LOGGER.info("");
                PortalShell.LOGGER.info("Export and Delete Support by Data Type");
                PortalDataHandlerServiceUtils.format((IPortalDataHandlerService)this.portalDataHandlerService, (Logger)PortalShell.LOGGER);
                PortalShell.LOGGER.info("Add -Dtype=dataType To get a list of data keys for the type");
            } else {
                Iterable data = this.portalDataHandlerService.getPortalData(type);
                PortalShell.LOGGER.info("");
                PortalShell.LOGGER.info("");
                PortalShell.LOGGER.info("All " + type + " data");
                PortalDataHandlerServiceUtils.format((Iterable)data, (Logger)PortalShell.LOGGER);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(target + " failed", e);
        }
    }

    public void dataExport(String target, String dataDir, String type, String sysid, String logDir) {
        PortalShell.LOGGER.info("");
        PortalShell.LOGGER.info("");
        File dataDirFile = new File(dataDir);
        if (StringUtils.isNotBlank((String)type) && StringUtils.isNotBlank((String)sysid)) {
            try {
                for (String id : COMMA_DELIM.split(sysid)) {
                    PortalShell.LOGGER.info("Exporting Data " + id + " of type " + type + " to: " + dataDir);
                    this.portalDataHandlerService.exportData(type, id, dataDirFile);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(target + " to " + dataDir + " of " + type + " " + sysid + " failed", e);
            }
        }
        if (StringUtils.isNotBlank((String)type)) {
            try {
                ImmutableSet types = ImmutableSet.copyOf((Object[])COMMA_DELIM.split(type));
                if (types.size() == 1) {
                    PortalShell.LOGGER.info("Exporting All Data of type " + type + " to: " + dataDir);
                } else {
                    PortalShell.LOGGER.info("Exporting All Data of types " + types + " to: " + dataDir);
                }
                this.portalDataHandlerService.exportAllDataOfType((Set)types, dataDirFile, new IPortalDataHandlerService.BatchExportOptions().setLogDirectoryParent(logDir));
            }
            catch (Exception e) {
                throw new RuntimeException(target + " to " + dataDir + " of " + type + " failed", e);
            }
        }
        try {
            PortalShell.LOGGER.info("Exporting All Data to: " + dataDir);
            this.portalDataHandlerService.exportAllData(dataDirFile, new IPortalDataHandlerService.BatchExportOptions().setLogDirectoryParent(logDir));
        }
        catch (Exception e) {
            throw new RuntimeException(target + " to " + dataDir + " failed", e);
        }
    }

    public void dataImport(String target, String dataDir, String pattern, String file, String logDir) {
        this.dataImport(target, dataDir, pattern, file, null, logDir);
    }

    public void dataImport(String target, String dataDir, String pattern, String file, String archive, String logDir) {
        PortalShell.LOGGER.info("");
        PortalShell.LOGGER.info("");
        if (!StringUtils.isBlank((String)file)) {
            PortalShell.LOGGER.info("Importing Data from: " + file);
            try {
                this.portalDataHandlerService.importData((Resource)new FileSystemResource(file));
            }
            catch (Exception e) {
                throw new RuntimeException(target + " for " + file + " failed", e);
            }
        } else if (!StringUtils.isBlank((String)archive)) {
            PortalShell.LOGGER.info("Importing Data from: " + archive);
            try {
                this.portalDataHandlerService.importDataArchive((Resource)new FileSystemResource(archive), new IPortalDataHandlerService.BatchImportOptions().setLogDirectoryParent(logDir));
            }
            catch (Exception e) {
                throw new RuntimeException(target + " for " + archive + " failed", e);
            }
        } else if (!StringUtils.isBlank((String)dataDir)) {
            PortalShell.LOGGER.info("Importing Data from: " + dataDir + " that matches " + pattern);
            pattern = StringUtils.trimToNull((String)pattern);
            try {
                this.portalDataHandlerService.importData(new File(dataDir), pattern, new IPortalDataHandlerService.BatchImportOptions().setLogDirectoryParent(logDir));
            }
            catch (Exception e) {
                if (pattern != null) {
                    throw new RuntimeException(target + " from " + dataDir + " matching " + pattern + " failed", e);
                }
                throw new RuntimeException(target + " from " + dataDir + " failed", e);
            }
        } else {
            throw new RuntimeException(target + " failed: One of dataDir, file, or archive must be specified");
        }
    }

    public void dataDelete(String target, String type, String sysid) {
        PortalShell.LOGGER.info("");
        PortalShell.LOGGER.info("");
        for (String id : COMMA_DELIM.split(sysid)) {
            try {
                PortalShell.LOGGER.info("Deleting Data " + id + " of type " + type);
                this.portalDataHandlerService.deleteData(type, id);
            }
            catch (Exception e) {
                throw new RuntimeException(target + " for " + type + " and " + id + " failed", e);
            }
        }
    }

    public void deleteUser(String target, String user) {
        try {
            PortalShell.LOGGER.info("");
            PortalShell.LOGGER.info("");
            this.userIdentityStore.removePortalUID(user);
        }
        catch (Exception e) {
            throw new RuntimeException(target + " for " + user + " failed", e);
        }
    }

    private ISchemaExport getSchemaExport(String persistenceUnit) {
        for (ISchemaExport schemaExport : this.schemaExportBeans.values()) {
            if (!persistenceUnit.equals(schemaExport.getPersistenceUnitName())) continue;
            return schemaExport;
        }
        throw new IllegalArgumentException("No ISchemaExport bean found for persistence unit: '" + persistenceUnit + "'");
    }
}

