/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.locator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.spring.PortalApplicationContextLocator;
import org.jasig.portal.spring.locator.AbstractBeanLocator;
import org.springframework.context.ApplicationContext;

public class ApplicationContextLocator
extends AbstractBeanLocator<ApplicationContext> {
    public static final String BEAN_NAME = "applicationContext";
    private static final Log LOG = LogFactory.getLog(ApplicationContextLocator.class);
    private static AbstractBeanLocator<ApplicationContext> locatorInstance;

    public static ApplicationContext getApplicationContext() {
        AbstractBeanLocator locator = locatorInstance;
        if (locator == null) {
            LOG.info((Object)"Looking up bean 'applicationContext' in ApplicationContext due to context not yet being initialized");
            ApplicationContext applicationContext = PortalApplicationContextLocator.getApplicationContext();
            applicationContext.getBean(ApplicationContextLocator.class.getName());
            locator = locatorInstance;
            if (locator == null) {
                LOG.warn((Object)"Instance of 'applicationContext' still null after portal application context has been initialized");
                return (ApplicationContext)applicationContext.getBean(BEAN_NAME, ApplicationContext.class);
            }
        }
        return (ApplicationContext)locator.getInstance();
    }

    public ApplicationContextLocator(ApplicationContext instance) {
        super((Object)instance, ApplicationContext.class);
    }

    protected AbstractBeanLocator<ApplicationContext> getLocator() {
        return locatorInstance;
    }

    protected void setLocator(AbstractBeanLocator<ApplicationContext> locator) {
        locatorInstance = locator;
    }
}

