/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.properties;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class MappingJackson2JsonTreeEditor
extends PropertyEditorSupport {
    private ObjectMapper objectMapper = new ObjectMapper();

    @Autowired(required=false)
    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public void setValue(Object value) {
        if (value != null && !(value instanceof JsonNode)) {
            throw new IllegalArgumentException("Only values of type " + JsonNode.class.getName() + " are supported. Was " + value.getClass().getName());
        }
        super.setValue(value);
    }

    @Override
    public String getAsText() {
        try {
            return this.objectMapper.writeValueAsString(this.getValue());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert JsonNode into JSON text", e);
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        JsonNode value;
        try {
            value = this.objectMapper.readTree(text);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert JSON text into JsonNode", e);
        }
        super.setValue(value);
    }
}

