/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.dbloader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.jasig.portal.hibernate.DelegatingHibernateIntegrator;
import org.jasig.portal.hibernate.HibernateConfigurationAware;
import org.jasig.portal.tools.dbloader.DataXmlHandler;
import org.jasig.portal.tools.dbloader.DbLoaderConfig;
import org.jasig.portal.tools.dbloader.IDbLoader;
import org.jasig.portal.tools.dbloader.ITableDataProvider;
import org.jasig.portal.tools.dbloader.TableXmlHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionOperations;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component(value="dbLoader")
@Lazy
@DependsOn(value={"PortalDbEntityManagerFactory", "hibernateConfigurationAwareInjector"})
public class HibernateDbLoader
implements IDbLoader,
ResourceLoaderAware,
HibernateConfigurationAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Configuration configuration;
    private Dialect dialect;
    private JdbcOperations jdbcOperations;
    private TransactionOperations transactionOperations;
    private ResourceLoader resourceLoader;

    @Autowired
    public void setJdbcOperations(@Qualifier(value="PortalDb") JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    @Autowired
    public void setTransactionOperations(@Qualifier(value="PortalDb") TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
    }

    public boolean supports(String persistenceUnit) {
        return "PortalDb".equals(persistenceUnit);
    }

    public void setConfiguration(String persistenceUnit, DelegatingHibernateIntegrator.HibernateConfiguration hibernateConfiguration) {
        SessionFactoryImplementor sessionFactory = hibernateConfiguration.getSessionFactory();
        this.dialect = sessionFactory.getDialect();
        this.configuration = hibernateConfiguration.getConfiguration();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void process(DbLoaderConfig configuration) throws ParserConfigurationException, SAXException, IOException {
        String scriptFile = configuration.getScriptFile();
        LinkedList script = scriptFile == null ? null : new LinkedList();
        ITableDataProvider tableData = this.loadTables(configuration, this.dialect);
        if (configuration.isDropTables() || configuration.isCreateTables()) {
            Map tables = tableData.getTables();
            Mapping mapping = this.configuration.buildMapping();
            String defaultCatalog = this.configuration.getProperty("hibernate.default_catalog");
            String defaultSchema = this.configuration.getProperty("hibernate.default_schema");
            LinkedHashMap<String, DataAccessException> failedSql = new LinkedHashMap<String, DataAccessException>();
            if (configuration.isDropTables()) {
                List dropScript = this.dropScript(tables.values(), this.dialect, defaultCatalog, defaultSchema);
                if (script == null) {
                    this.logger.info((Object)"Dropping existing tables");
                    for (String sql : dropScript) {
                        this.logger.info((Object)sql);
                        try {
                            this.jdbcOperations.update(sql);
                        }
                        catch (NonTransientDataAccessResourceException dae) {
                            throw dae;
                        }
                        catch (DataAccessException dae) {
                            failedSql.put(sql, dae);
                        }
                    }
                } else {
                    script.addAll(dropScript);
                }
            }
            for (Map.Entry failedSqlEntry : failedSql.entrySet()) {
                this.logger.warn((Object)("'" + (String)failedSqlEntry.getKey() + "' failed to execute due to " + failedSqlEntry.getValue()));
            }
            if (configuration.isCreateTables()) {
                List createScript = this.createScript(tables.values(), this.dialect, mapping, defaultCatalog, defaultSchema);
                if (script == null) {
                    this.logger.info((Object)"Creating tables");
                    for (String sql : createScript) {
                        this.logger.info((Object)sql);
                        this.jdbcOperations.update(sql);
                    }
                } else {
                    script.addAll(createScript);
                }
            }
        }
        if (script == null && configuration.isPopulateTables()) {
            this.logger.info((Object)"Populating database");
            Map tableColumnTypes = tableData.getTableColumnTypes();
            this.populateTables(configuration, tableColumnTypes);
        }
        if (script != null) {
            ListIterator<String> iterator = script.listIterator();
            while (iterator.hasNext()) {
                String sql = (String)iterator.next();
                iterator.set(sql + ";");
            }
            File outputFile = new File(scriptFile);
            FileUtils.writeLines((File)outputFile, script);
            this.logger.info((Object)("Saved DDL to: " + outputFile.getAbsolutePath()));
        }
    }

    protected ITableDataProvider loadTables(DbLoaderConfig configuration, Dialect dialect) throws ParserConfigurationException, SAXException, IOException {
        String tablesFileName = configuration.getTablesFile();
        Resource tablesFile = this.resourceLoader.getResource(tablesFileName);
        if (!tablesFile.exists()) {
            throw new IllegalArgumentException("Could not find tables file: " + tablesFile);
        }
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        TableXmlHandler dh = new TableXmlHandler(dialect);
        saxParser.parse(new InputSource(tablesFile.getInputStream()), (DefaultHandler)dh);
        return dh;
    }

    protected List<String> dropScript(Collection<Table> tables, Dialect dialect, String defaultCatalog, String defaultSchema) {
        ArrayList<String> script = new ArrayList<String>(tables.size() * 2);
        if (dialect.dropConstraints()) {
            for (Table table : tables) {
                if (!table.isPhysicalTable()) continue;
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    script.add(fk.sqlDropString(dialect, defaultCatalog, defaultSchema));
                }
            }
        }
        for (Table table : tables) {
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlDropString(dialect, defaultCatalog, defaultSchema));
        }
        return script;
    }

    protected List<String> createScript(Collection<Table> tables, Dialect dialect, Mapping mapping, String defaultCatalog, String defaultSchema) {
        ArrayList<String> script = new ArrayList<String>(tables.size() * 2);
        for (Table table : tables) {
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlCreateString(dialect, mapping, defaultCatalog, defaultSchema));
        }
        for (Table table : tables) {
            Iterator subIter;
            if (!table.isPhysicalTable()) continue;
            if (!dialect.supportsUniqueConstraintInCreateAlterTable()) {
                subIter = table.getUniqueKeyIterator();
                while (subIter.hasNext()) {
                    UniqueKey uk = (UniqueKey)subIter.next();
                    String constraintString = uk.sqlCreateString(dialect, mapping, defaultCatalog, defaultSchema);
                    if (constraintString == null) continue;
                    script.add(constraintString);
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                script.add(index.sqlCreateString(dialect, mapping, defaultCatalog, defaultSchema));
            }
            if (!dialect.hasAlterTable()) continue;
            subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                ForeignKey fk = (ForeignKey)subIter.next();
                if (!fk.isPhysicalConstraint()) continue;
                script.add(fk.sqlCreateString(dialect, mapping, defaultCatalog, defaultSchema));
            }
        }
        return script;
    }

    protected void populateTables(DbLoaderConfig configuration, Map<String, Map<String, Integer>> tableColumnTypes) throws ParserConfigurationException, SAXException, IOException {
        String dataFileName = configuration.getDataFile();
        Resource dataFile = this.resourceLoader.getResource(dataFileName);
        if (!dataFile.exists()) {
            throw new IllegalArgumentException("Could not find data file: " + dataFile);
        }
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        DataXmlHandler dh = new DataXmlHandler(this.jdbcOperations, this.transactionOperations, tableColumnTypes);
        saxParser.parse(new InputSource(dataFile.getInputStream()), (DefaultHandler)dh);
    }
}

