/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.dbloader;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.jasig.portal.tools.dbloader.BaseDbXmlHandler;
import org.jasig.portal.tools.dbloader.ITableDataProvider;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TableXmlHandler
extends BaseDbXmlHandler
implements ITableDataProvider {
    private final Mappings mappings = new Configuration().createMappings();
    private final Dialect dialect;
    private Map<String, Table> tables = new LinkedHashMap();
    private Map<String, Map<String, Integer>> tableColumnTypes = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Table currentTable = null;
    private Map<String, Column> currentColumns = null;
    private Map<String, Integer> currentColumnTypes = null;
    private Column currentColumn = null;
    private PrimaryKey primaryKey = null;
    private Index currentIndex = null;
    private UniqueKey currentUnique = null;

    public TableXmlHandler(Dialect dialect) {
        this.dialect = dialect;
    }

    public Map<String, Table> getTables() {
        return this.tables;
    }

    public Map<String, Map<String, Integer>> getTableColumnTypes() {
        return this.tableColumnTypes;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("table".equals(name)) {
            this.currentColumns = new LinkedHashMap();
            this.currentColumnTypes = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        } else if ("index".equals(name)) {
            this.currentIndex = new Index();
            this.currentIndex.setTable(this.currentTable);
        } else if ("unique".equals(name)) {
            this.currentUnique = new UniqueKey();
            this.currentUnique.setTable(this.currentTable);
        }
        this.chars = new StringBuilder();
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("table".equals(name)) {
            for (Column column : this.currentColumns.values()) {
                this.currentTable.addColumn(column);
            }
            if (this.primaryKey != null) {
                this.currentTable.setPrimaryKey(this.primaryKey);
            }
            this.tables.put(this.currentTable.getName(), this.currentTable);
            this.tableColumnTypes.put(this.currentTable.getName(), this.currentColumnTypes);
            this.primaryKey = null;
            this.currentColumns = null;
            this.currentColumnTypes = null;
            this.currentTable = null;
        } else if ("column".equals(name)) {
            this.currentColumns.put(this.currentColumn.getName(), this.currentColumn);
            this.currentColumn = null;
        } else if ("name".equals(name)) {
            String itemName = this.chars.toString().trim();
            if (this.currentIndex != null) {
                this.currentIndex.setName(itemName);
            } else if (this.currentUnique != null) {
                this.currentUnique.setName(itemName);
            } else if (this.currentTable == null) {
                this.currentTable = new Table(itemName);
            } else if (this.currentColumn == null) {
                this.currentColumn = new Column(itemName);
            }
        } else if ("type".equals(name)) {
            String sqlTypeName = this.chars.toString().trim();
            int sqlType = this.getSqlType(sqlTypeName);
            this.currentColumnTypes.put(this.currentColumn.getName(), sqlType);
            String hibType = this.getHibernateType(sqlType);
            SimpleValue value = new SimpleValue(this.mappings, this.currentTable);
            value.setTypeName(hibType);
            this.currentColumn.setValue((Value)value);
        } else if ("param".equals(name)) {
            String param = this.chars.toString().trim();
            Integer length = Integer.valueOf(param);
            this.currentColumn.setLength(length.intValue());
        } else if ("primary-key".equals(name)) {
            String columnName = this.chars.toString().trim();
            if (this.primaryKey == null) {
                this.primaryKey = new PrimaryKey();
            }
            Column column = (Column)this.currentColumns.get(columnName);
            this.primaryKey.addColumn(column);
        } else if ("not-null".equals(name)) {
            String columnName = this.chars.toString().trim();
            Column column = (Column)this.currentColumns.get(columnName);
            column.setNullable(false);
        } else if ("column-ref".equals(name)) {
            String columnName = this.chars.toString().trim();
            Column column = (Column)this.currentColumns.get(columnName);
            if (this.currentIndex != null) {
                this.currentIndex.addColumn(column);
            } else if (this.currentUnique != null) {
                this.currentUnique.addColumn(column);
            }
        } else if ("index".equals(name)) {
            this.currentTable.addIndex(this.currentIndex);
            this.currentIndex = null;
        } else if ("unique".equals(name)) {
            this.currentTable.addUniqueKey(this.currentUnique);
            this.currentUnique = null;
        } else if ("key".equals(name)) {
            this.logger.warn((Object)"the 'key' element is ignored, use the table level 'primary-key' element instead");
        }
        this.chars = null;
    }

    protected int getSqlType(String sqlTypeName) {
        try {
            Field sqlTypeField = Types.class.getField(sqlTypeName);
            return sqlTypeField.getInt(null);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Cannot access field '" + sqlTypeName + "' on " + Types.class + " for column '" + this.currentColumn.getName() + "'", e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("No SQL Type field '" + sqlTypeName + "' on " + Types.class + " for column '" + this.currentColumn.getName() + "'", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot access field '" + sqlTypeName + "' on " + Types.class + " for column '" + this.currentColumn.getName() + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access field '" + sqlTypeName + "' on " + Types.class + " for column '" + this.currentColumn.getName() + "'", e);
        }
    }

    protected String getHibernateType(int sqlType) {
        String hibType;
        try {
            hibType = this.dialect.getHibernateTypeName(sqlType);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException("No mapped hibernate type found for '" + sqlType + "' Types value=" + sqlType + " for column '" + this.currentColumn.getName() + "'", e);
        }
        return hibType;
    }
}

