/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jasig.portal.url.IUrlBuilder;
import org.jasig.portal.url.ParameterMap;

public abstract class AbstractUrlBuilder
implements IUrlBuilder {
    private final Map<String, String[]> parameters = MapConstraints.constrainedMap((Map)new ParameterMap(), (MapConstraint)new /* Unavailable Anonymous Inner Class!! */);

    public final Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public final void addParameter(String name, String ... values) {
        Validate.notNull((Object)values, (String)"values can not be null");
        Object[] valuesList = (String[])this.parameters.get(name);
        valuesList = valuesList == null ? Arrays.copyOf(values, values.length) : (String[])ObjectArrays.concat((Object[])valuesList, (Object[])values, String.class);
        this.parameters.put(name, valuesList);
    }

    public final void setParameter(String name, String ... values) {
        Validate.notNull((Object)values, (String)"values can not be null");
        String[] valuesList = Arrays.copyOf(values, values.length);
        this.parameters.put(name, valuesList);
    }

    public void setParameter(String name, List<String> values) {
        Validate.notNull(values, (String)"values can not be null");
        this.parameters.put(name, values.toArray(new String[values.size()]));
    }

    public final void setParameters(Map<String, List<String>> parameters) {
        this.parameters.clear();
        for (Map.Entry<String, List<String>> parameterEntry : parameters.entrySet()) {
            this.setParameter(parameterEntry.getKey(), parameterEntry.getValue());
        }
    }

    public String toString() {
        return "AbstractPortalUrl [parameters=" + this.parameters + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractUrlBuilder other = (AbstractUrlBuilder)obj;
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }
}

