/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.url.PortalHttpServletRequestWrapper;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.ArrayEnumerator;
import org.jasig.portal.utils.Servlet3WrapperUtils;
import org.jasig.portal.utils.web.AbstractHttpServletRequestWrapper;

public class PortalHttpServletRequestWrapperImpl
extends AbstractHttpServletRequestWrapper
implements PortalHttpServletRequestWrapper {
    public static final String ATTRIBUTE__HTTP_SERVLET_REQUEST = PortalHttpServletRequestWrapperImpl.class.getName() + ".PORTAL_HTTP_SERVLET_REQUEST";
    public static final String ATTRIBUTE__HTTP_SERVLET_RESPONSE = PortalHttpServletRequestWrapperImpl.class.getName() + ".PORTAL_HTTP_SERVLET_RESPONSE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, Object> additionalHeaders = new LinkedHashMap();
    private final HttpServletResponse httpServletResponse;
    private final IUserInstanceManager userInstanceManager;
    private HttpServletRequest servlet3Wrapper;

    public static PortalHttpServletRequestWrapper create(HttpServletRequest request, HttpServletResponse response, IUserInstanceManager userInstanceManager) {
        PortalHttpServletRequestWrapperImpl proxy = new PortalHttpServletRequestWrapperImpl(request, response, userInstanceManager);
        PortalHttpServletRequestWrapper wrapper = (PortalHttpServletRequestWrapper)Servlet3WrapperUtils.addServlet3Wrapper((Object)proxy, (Object)request);
        proxy.servlet3Wrapper = wrapper;
        return wrapper;
    }

    private PortalHttpServletRequestWrapperImpl(HttpServletRequest request, HttpServletResponse response, IUserInstanceManager userInstanceManager) {
        super(request);
        Validate.notNull((Object)response);
        Validate.notNull((Object)userInstanceManager);
        this.httpServletResponse = response;
        this.userInstanceManager = userInstanceManager;
        this.servlet3Wrapper = this;
    }

    public void setHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public void setDateHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public void setIntHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public long getDateHeader(String name) {
        Object value = this.additionalHeaders.get(name);
        if (value == null) {
            return super.getDateHeader(name);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new IllegalArgumentException("Header '" + name + "' cannot be converted to long: '" + value + "' is of type " + value.getClass().getName());
    }

    public String getHeader(String name) {
        Object value = this.additionalHeaders.get(name);
        if (value == null) {
            return super.getHeader(name);
        }
        return String.valueOf(value);
    }

    public Enumeration<?> getHeaders(String name) {
        Object value = this.additionalHeaders.get(name);
        if (value == null) {
            return super.getHeaders(name);
        }
        return Collections.enumeration(Collections.singleton(value));
    }

    public Enumeration<?> getHeaderNames() {
        LinkedHashSet<Object> headerNames = new LinkedHashSet<Object>();
        Enumeration headerNamesEnum = super.getHeaderNames();
        while (headerNamesEnum.hasMoreElements()) {
            Object name = headerNamesEnum.nextElement();
            headerNames.add(name);
        }
        headerNames.addAll(this.additionalHeaders.keySet());
        return Collections.enumeration(headerNames);
    }

    public int getIntHeader(String name) {
        Object value = this.additionalHeaders.get(name);
        if (value == null) {
            return super.getIntHeader(name);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new IllegalArgumentException("Header '" + name + "' cannot be converted to int: '" + value + "' is of type " + value.getClass().getName());
    }

    public Object getAttribute(String name) {
        if (ATTRIBUTE__HTTP_SERVLET_REQUEST.equals(name)) {
            return this.servlet3Wrapper;
        }
        if (ATTRIBUTE__HTTP_SERVLET_RESPONSE.equals(name)) {
            return this.httpServletResponse;
        }
        return super.getAttribute(name);
    }

    public String getRemoteUser() {
        Principal userPrincipal = this.getUserPrincipal();
        if (userPrincipal == null) {
            return null;
        }
        return userPrincipal.getName();
    }

    public Principal getUserPrincipal() {
        if (super.getSession(false) == null) {
            return super.getUserPrincipal();
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(this.getWrappedRequest());
        IPerson person = userInstance.getPerson();
        if (person == null || person.isGuest()) {
            return null;
        }
        return person;
    }

    public boolean isUserInRole(String role) {
        if (super.getSession(false) == null) {
            return super.isUserInRole(role);
        }
        boolean isUserInRole = super.isUserInRole(role);
        if (isUserInRole) {
            return true;
        }
        IEntityGroup groupForRole = GroupService.findGroup((String)role);
        if (groupForRole == null) {
            EntityIdentifier[] results = GroupService.searchForGroups((String)role, (int)1, IPerson.class);
            if (results == null || results.length == 0) {
                return false;
            }
            if (results.length > 1) {
                this.logger.warn((Object)(results.length + " groups were found for role '" + role + "'. The first result will be used."));
            }
            groupForRole = GroupService.getGroupMember((EntityIdentifier)results[0]);
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(this.getWrappedRequest());
        IPerson person = userInstance.getPerson();
        EntityIdentifier personEntityId = person.getEntityIdentifier();
        IGroupMember personGroupMember = GroupService.getGroupMember((EntityIdentifier)personEntityId);
        return personGroupMember.isDeepMemberOf((IGroupMember)groupForRole);
    }

    public Locale getLocale() {
        if (super.getSession(false) == null) {
            return super.getLocale();
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(this.getWrappedRequest());
        LocaleManager localeManager = userInstance.getLocaleManager();
        Locale[] locales = localeManager.getLocales();
        return locales[0];
    }

    public Enumeration<Locale> getLocales() {
        if (super.getSession(false) == null) {
            return super.getLocales();
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(this.getWrappedRequest());
        LocaleManager localeManager = userInstance.getLocaleManager();
        Object[] locales = localeManager.getLocales();
        return new ArrayEnumerator(locales);
    }
}

