/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IPortletRequestInfo;
import org.jasig.portal.url.ParameterMap;
import org.jasig.portal.url.UrlType;

class PortletRequestInfoImpl
implements IPortletRequestInfo {
    private final Object readOnlySync = new Object();
    private final IPortletWindowId targetWindowId;
    private final IPortalRequestInfo portalRequestInfo;
    private volatile boolean readOnly = false;
    private Map<String, List<String>> portletParameters = new LinkedHashMap();
    private WindowState windowState;
    private PortletMode portletMode;
    private IPortletWindowId delegateParentWindowId;
    private String resourceId;
    private String cacheability = "cacheLevelPage";

    public PortletRequestInfoImpl(IPortletWindowId targetWindowId, IPortalRequestInfo portalRequestInfo) {
        this.targetWindowId = targetWindowId;
        this.portalRequestInfo = portalRequestInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeReadOnly() {
        Object object = this.readOnlySync;
        synchronized (object) {
            if (this.readOnly) {
                return;
            }
            this.portletParameters = ParameterMap.immutableCopyOfListMap((Map)this.portletParameters);
            this.readOnly = true;
        }
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("makeReadOnly has been called, this object is in read-only mode");
        }
    }

    public Map<String, List<String>> getPortletParameters() {
        return this.portletParameters;
    }

    public IPortletWindowId getDelegateParentWindowId() {
        return this.delegateParentWindowId;
    }

    public void setDelegateParentWindowId(IPortletWindowId delegateParentWindowId) {
        this.checkReadOnly();
        this.delegateParentWindowId = delegateParentWindowId;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void setWindowState(WindowState windowState) {
        this.checkReadOnly();
        this.windowState = windowState;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public void setPortletMode(PortletMode portletMode) {
        this.checkReadOnly();
        this.portletMode = portletMode;
    }

    public String getResourceId() {
        UrlType urlType = this.portalRequestInfo.getUrlType();
        Preconditions.checkArgument((urlType == UrlType.RESOURCE ? 1 : 0) != 0, (String)"UrlType must be %s but was %s", (Object[])new Object[]{UrlType.RESOURCE, urlType});
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.checkReadOnly();
        this.resourceId = resourceId;
    }

    public String getCacheability() {
        UrlType urlType = this.portalRequestInfo.getUrlType();
        Preconditions.checkArgument((urlType == UrlType.RESOURCE ? 1 : 0) != 0, (String)"UrlType must be %s but was %s", (Object[])new Object[]{UrlType.RESOURCE, urlType});
        return this.cacheability;
    }

    public void setCacheability(String cacheability) {
        this.checkReadOnly();
        this.cacheability = cacheability;
    }

    public IPortletWindowId getPortletWindowId() {
        return this.targetWindowId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.targetWindowId == null ? 0 : this.targetWindowId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortletRequestInfoImpl other = (PortletRequestInfoImpl)obj;
        return !(this.targetWindowId == null ? other.targetWindowId != null : !this.targetWindowId.equals(other.targetWindowId));
    }

    public String toString() {
        return "PortletRequestInfoImpl [targetWindowId=" + this.targetWindowId + ", portletParameters=" + this.portletParameters + ", windowState=" + this.windowState + ", portletMode=" + this.portletMode + ", resourceId=" + this.resourceId + ", cacheability=" + this.cacheability + "]";
    }
}

