/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.url.AbstractUrlBuilder;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.ParameterMap;
import org.jasig.portal.url.UrlType;

class PortletUrlBuilder
extends AbstractUrlBuilder
implements IPortletUrlBuilder {
    private final IPortletWindowId portletWindowId;
    private final IPortalUrlBuilder portalUrlBuilder;
    private final UrlType urlType;
    private final Map<String, String[]> publicRenderParameters;
    private WindowState windowState = null;
    private PortletMode portletMode = null;
    private String resourceId = null;
    private String cacheability = null;
    private boolean copyCurrentRenderParameters = false;

    public PortletUrlBuilder(IPortletWindowId portletWindowId, IPortalUrlBuilder portalUrlBuilder) {
        Preconditions.checkNotNull((Object)portletWindowId, (Object)"IPortletWindowId can not be null");
        Preconditions.checkNotNull((Object)portalUrlBuilder, (Object)"IPortalUrlBuilder can not be null");
        this.portletWindowId = portletWindowId;
        this.portalUrlBuilder = portalUrlBuilder;
        this.urlType = this.portalUrlBuilder.getUrlType();
        this.publicRenderParameters = MapConstraints.constrainedMap((Map)new ParameterMap(), (MapConstraint)new /* Unavailable Anonymous Inner Class!! */);
    }

    public IPortletWindowId getPortletWindowId() {
        return this.portletWindowId;
    }

    public IPortalUrlBuilder getPortalUrlBuilder() {
        return this.portalUrlBuilder;
    }

    public void setCopyCurrentRenderParameters(boolean copyCurrentRenderParameters) {
        this.copyCurrentRenderParameters = copyCurrentRenderParameters;
    }

    public boolean getCopyCurrentRenderParameters() {
        return this.copyCurrentRenderParameters;
    }

    public void setWindowState(WindowState windowState) {
        this.windowState = windowState;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void setPortletMode(PortletMode portletMode) {
        this.portletMode = portletMode;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public void setResourceId(String resourceId) {
        Preconditions.checkArgument((this.urlType == UrlType.RESOURCE ? 1 : 0) != 0, (String)"UrlType must be %s but was %s", (Object[])new Object[]{UrlType.RESOURCE, this.urlType});
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        Preconditions.checkArgument((this.urlType == UrlType.RESOURCE ? 1 : 0) != 0, (String)"UrlType must be %s but was %s", (Object[])new Object[]{UrlType.RESOURCE, this.urlType});
        return this.resourceId;
    }

    public void setCacheability(String cacheability) {
        Preconditions.checkArgument((this.urlType == UrlType.RESOURCE ? 1 : 0) != 0, (String)"UrlType must be %s but was %s", (Object[])new Object[]{UrlType.RESOURCE, this.urlType});
        this.cacheability = cacheability;
    }

    public String getCacheability() {
        Preconditions.checkArgument((this.urlType == UrlType.RESOURCE ? 1 : 0) != 0, (String)"UrlType must be %s but was %s", (Object[])new Object[]{UrlType.RESOURCE, this.urlType});
        return this.cacheability;
    }

    public Map<String, String[]> getPublicRenderParameters() {
        return this.publicRenderParameters;
    }

    public String toString() {
        return "PortletUrlBuilder [portletWindowId=" + this.portletWindowId + ", windowState=" + this.windowState + ", portletMode=" + this.portletMode + ", resourceId=" + this.resourceId + ", cacheability=" + this.cacheability + ", parameters=" + this.getParameters() + ", publicRenderParameters=" + this.publicRenderParameters + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cacheability == null ? 0 : this.cacheability.hashCode());
        result = 31 * result + (this.portletMode == null ? 0 : this.portletMode.hashCode());
        result = 31 * result + (this.portletWindowId == null ? 0 : this.portletWindowId.hashCode());
        result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
        result = 31 * result + (this.windowState == null ? 0 : this.windowState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortletUrlBuilder other = (PortletUrlBuilder)obj;
        if (this.cacheability == null ? other.cacheability != null : !this.cacheability.equals(other.cacheability)) {
            return false;
        }
        if (this.portletMode == null ? other.portletMode != null : !this.portletMode.equals((Object)other.portletMode)) {
            return false;
        }
        if (this.portletWindowId == null ? other.portletWindowId != null : !this.portletWindowId.equals(other.portletWindowId)) {
            return false;
        }
        if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
            return false;
        }
        return !(this.windowState == null ? other.windowState != null : !this.windowState.equals((Object)other.windowState));
    }
}

