/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import com.google.common.base.Function;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalException;
import org.jasig.portal.concurrency.caching.RequestCache;
import org.jasig.portal.dao.usertype.FunctionalNameType;
import org.jasig.portal.layout.INodeIdResolver;
import org.jasig.portal.layout.IStylesheetUserPreferencesService;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.PortletTabIdResolver;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.layout.om.IStylesheetParameterDescriptor;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.url.IUrlNodeSyntaxHelper;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.xml.xpath.XPathOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SingleTabUrlNodeSyntaxHelper
implements IUrlNodeSyntaxHelper {
    public static final String EXTERNAL_ID_ATTR = "externalId";
    private static final char PORTLET_PATH_ELEMENT_SEPERATOR = '.';
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String defaultLayoutNodeIdExpression = "/layout/folder/folder[@type='regular' and @hidden!='true'][$defaultTab]/@ID";
    private String defaultTabParameter = "defaultTab";
    private IUserInstanceManager userInstanceManager;
    private XPathOperations xpathOperations;
    private IStylesheetUserPreferencesService stylesheetUserPreferencesService;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setXpathOperations(XPathOperations xpathOperations) {
        this.xpathOperations = xpathOperations;
    }

    @Autowired
    public void setStylesheetUserPreferencesService(IStylesheetUserPreferencesService stylesheetUserPreferencesService) {
        this.stylesheetUserPreferencesService = stylesheetUserPreferencesService;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getDefaultLayoutNodeId(HttpServletRequest httpServletRequest) {
        String defaultTabId;
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(httpServletRequest);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        IUserLayout userLayout = userLayoutManager.getUserLayout();
        String defaultTabIndex = this.getDefaultTabIndex(httpServletRequest);
        if (defaultTabIndex != null && StringUtils.isNotEmpty((String)(defaultTabId = this.getTabId(userLayout, defaultTabIndex)))) {
            return defaultTabId;
        }
        this.logger.warn("Failed to find default tab id for '" + userInstance.getPerson().getUserName() + "' with default tab index " + defaultTabIndex + ". Index 1 will be tried as a fall-back.");
        String firstTabId = this.getTabId(userLayout, "1");
        if (StringUtils.isNotEmpty((String)firstTabId)) {
            return firstTabId;
        }
        this.logger.warn("Failed to find default tab id for '" + userInstance.getPerson().getUserName() + "' with default tab index 1. The user has no tabs.");
        return userLayout.getRootId();
    }

    protected String getTabId(IUserLayout userLayout, String tabIndex) {
        return (String)this.xpathOperations.doWithExpression(this.defaultLayoutNodeIdExpression, Collections.singletonMap("defaultTab", tabIndex), (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected String getDefaultTabIndex(HttpServletRequest httpServletRequest) {
        String stylesheetParameter = this.stylesheetUserPreferencesService.getStylesheetParameter(httpServletRequest, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, this.defaultTabParameter);
        if (stylesheetParameter != null) {
            return stylesheetParameter;
        }
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetUserPreferencesService.getStylesheetDescriptor(httpServletRequest, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE);
        IStylesheetParameterDescriptor stylesheetParameterDescriptor = stylesheetDescriptor.getStylesheetParameterDescriptor(this.defaultTabParameter);
        if (stylesheetParameterDescriptor != null) {
            return stylesheetParameterDescriptor.getDefaultValue();
        }
        return null;
    }

    @RequestCache(keyMask={false, true})
    public List<String> getFolderNamesForLayoutNode(HttpServletRequest request, String layoutNodeId) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        IUserLayout userLayout = userLayoutManager.getUserLayout();
        String tabId = userLayout.findNodeId((INodeIdResolver)new PortletTabIdResolver(layoutNodeId));
        if (StringUtils.isEmpty((String)tabId)) {
            return Collections.emptyList();
        }
        String externalId = this.stylesheetUserPreferencesService.getLayoutAttribute(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, tabId, EXTERNAL_ID_ATTR);
        if (externalId != null) {
            Map allNodesAndValuesForAttribute = this.stylesheetUserPreferencesService.getAllNodesAndValuesForAttribute(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, EXTERNAL_ID_ATTR);
            boolean appendNodeId = false;
            for (Map.Entry nodeAttributeEntry : allNodesAndValuesForAttribute.entrySet()) {
                String entryNodeId = (String)nodeAttributeEntry.getKey();
                String entryValue = (String)nodeAttributeEntry.getValue();
                if (tabId.equals(entryNodeId) || !externalId.equals(entryValue)) continue;
                appendNodeId = true;
                break;
            }
            if (!FunctionalNameType.isValid((String)externalId)) {
                this.logger.warn("ExternalId {} for tab {} is not a valid fname. It will be converted for use in the URL but this results in additional overhead", (Object)externalId, (Object)tabId);
                externalId = FunctionalNameType.makeValid((String)externalId);
            }
            if (appendNodeId) {
                externalId = externalId + '.' + layoutNodeId;
            }
            return Arrays.asList(externalId);
        }
        return Arrays.asList(tabId);
    }

    public String getLayoutNodeForFolderNames(HttpServletRequest request, List<String> folderNames) {
        IUserLayoutNodeDescription node;
        if (folderNames == null || folderNames.isEmpty()) {
            return null;
        }
        String folderName = folderNames.get(0);
        String layoutNodeId = null;
        int seperatorIndex = folderName.indexOf(46);
        if (seperatorIndex > 0 && seperatorIndex < folderName.length() - 1) {
            layoutNodeId = folderName.substring(seperatorIndex + 1);
            folderName = folderName.substring(0, seperatorIndex);
        }
        String firstMatchingNodeId = null;
        Map allNodesAndValuesForAttribute = this.stylesheetUserPreferencesService.getAllNodesAndValuesForAttribute(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, EXTERNAL_ID_ATTR);
        for (Map.Entry entry : allNodesAndValuesForAttribute.entrySet()) {
            String value = (String)entry.getValue();
            if (!value.equals(folderName) && !FunctionalNameType.makeValid((String)value).equals(folderName)) continue;
            String nodeId = (String)entry.getKey();
            if (nodeId.equals(layoutNodeId)) {
                return nodeId;
            }
            if (firstMatchingNodeId != null) continue;
            firstMatchingNodeId = nodeId;
        }
        if (firstMatchingNodeId != null) {
            layoutNodeId = firstMatchingNodeId;
        } else if (layoutNodeId == null) {
            layoutNodeId = folderName;
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        try {
            node = userLayoutManager.getNode(layoutNodeId);
        }
        catch (PortalException e) {
            return null;
        }
        if (node == null) {
            return null;
        }
        return node.getId();
    }

    @RequestCache(keyMask={false, true})
    public String getFolderNameForPortlet(HttpServletRequest request, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        String fname = portletDefinition.getFName();
        String layoutNodeId = portletEntity.getLayoutNodeId();
        return fname + '.' + layoutNodeId;
    }

    public IPortletWindowId getPortletForFolderName(HttpServletRequest request, String targetedLayoutNodeId, String folderName) {
        IPortletWindow portletWindow;
        IUserInstance userInstance;
        String fname;
        String subscribeId = null;
        int seperatorIndex = folderName.indexOf(46);
        if (seperatorIndex <= 0 || seperatorIndex + 1 == folderName.length()) {
            fname = folderName;
        } else {
            fname = folderName.substring(0, seperatorIndex);
            subscribeId = folderName.substring(seperatorIndex + 1);
        }
        if (subscribeId != null) {
            userInstance = this.userInstanceManager.getUserInstance(request);
            IPortletEntity portletEntity = this.portletEntityRegistry.getOrCreatePortletEntity(request, userInstance, subscribeId);
            if (portletEntity == null || !fname.equals(portletEntity.getPortletDefinition().getFName())) {
                subscribeId = null;
            } else {
                IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
                IPortletWindow portletWindow2 = this.portletWindowRegistry.getOrCreateDefaultPortletWindow(request, portletEntityId);
                if (portletWindow2 == null) {
                    return null;
                }
                return portletWindow2.getPortletWindowId();
            }
        }
        if (targetedLayoutNodeId != null) {
            userInstance = this.userInstanceManager.getUserInstance(request);
            IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
            IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
            subscribeId = userLayoutManager.getSubscribeId(targetedLayoutNodeId, fname);
        }
        if ((portletWindow = subscribeId == null ? this.portletWindowRegistry.getOrCreateDefaultPortletWindowByFname(request, fname) : this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, subscribeId)) == null) {
            return null;
        }
        return portletWindow.getPortletWindowId();
    }
}

