/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class UrlStringBuilder
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final String encoding;
    private final String protocol;
    private final String host;
    private final Integer port;
    private final String context;
    private final List<String> path = new LinkedList();
    private final Map<String, List<String>> parameters = new LinkedHashMap();

    public UrlStringBuilder(String encoding, String context) {
        Validate.notNull((Object)encoding, (String)"encoding can not be null");
        this.checkEncoding(encoding);
        this.encoding = encoding;
        this.protocol = null;
        this.host = null;
        this.port = null;
        this.context = context;
    }

    public UrlStringBuilder(UrlStringBuilder urlBuilder) {
        Validate.notNull((Object)urlBuilder, (String)"urlBuilder can not be null");
        this.encoding = urlBuilder.encoding;
        this.host = urlBuilder.host;
        this.protocol = urlBuilder.protocol;
        this.port = urlBuilder.port;
        this.context = urlBuilder.context;
        this.path.addAll(urlBuilder.path);
        for (Map.Entry paramEntry : urlBuilder.parameters.entrySet()) {
            String key = (String)paramEntry.getKey();
            ArrayList value = (ArrayList)paramEntry.getValue();
            if (value != null) {
                value = new ArrayList(value);
            }
            this.parameters.put(key, value);
        }
    }

    protected void checkEncoding(String encoding) {
        try {
            URLEncoder.encode("", encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Encoding '" + encoding + "' is not supported", e);
        }
    }

    protected <T> List<T> copy(List<T> l) {
        return l == null ? null : new ArrayList<T>(l);
    }

    protected <T> List<T> copy(T[] t) {
        return t == null ? null : new ArrayList<T>(Arrays.asList(t));
    }

    protected String encode(String s) {
        try {
            return URLEncoder.encode(s, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding '" + this.encoding + "' is not supported. This should have been caught in the consructor.", e);
        }
    }

    public UrlStringBuilder setParameter(String name, String ... values) {
        this.setParameter(name, values != null ? Arrays.asList(values) : null);
        return this;
    }

    public UrlStringBuilder setParameter(String name, List<String> values) {
        Validate.notNull((Object)name, (String)"parameter name cannot be null");
        this.parameters.put(name, this.copy(values));
        return this;
    }

    public UrlStringBuilder addParameter(String name, String ... values) {
        this.addParameter(name, values != null ? Arrays.asList(values) : null);
        return this;
    }

    public UrlStringBuilder addParameter(String name, List<String> values) {
        Validate.notNull((Object)name, (String)"parameter name cannot be null");
        ArrayList<String> existingValues = (ArrayList<String>)this.parameters.get(name);
        if (existingValues == null) {
            existingValues = new ArrayList<String>(values != null ? values.size() : 0);
            this.parameters.put(name, existingValues);
        }
        if (values != null) {
            existingValues.addAll(values);
        }
        return this;
    }

    public UrlStringBuilder setParameters(Map<String, List<String>> parameters) {
        this.setParameters("", parameters);
        return this;
    }

    public UrlStringBuilder setParameters(String namespace, Map<String, List<String>> parameters) {
        for (String name : parameters.keySet()) {
            Validate.notNull((Object)name, (String)"parameter map cannot contain any null keys");
        }
        this.parameters.clear();
        this.addParameters(namespace, parameters);
        return this;
    }

    public UrlStringBuilder addParameters(Map<String, List<String>> parameters) {
        this.addParameters("", parameters);
        return this;
    }

    public UrlStringBuilder addParameters(String namespace, Map<String, List<String>> parameters) {
        for (String string : parameters.keySet()) {
            Validate.notNull((Object)string, (String)"parameter map cannot contain any null keys");
        }
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            List values = this.copy((List)entry.getValue());
            this.parameters.put(namespace + name, values);
        }
        return this;
    }

    public UrlStringBuilder addParametersArray(String namespace, Map<String, String[]> parameters) {
        for (String string : parameters.keySet()) {
            Validate.notNull((Object)string, (String)"parameter map cannot contain any null keys");
        }
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            List values = this.copy((Object[])entry.getValue());
            this.parameters.put(namespace + name, values);
        }
        return this;
    }

    public UrlStringBuilder setPath(String ... elements) {
        Validate.noNullElements((Object[])elements, (String)"elements cannot be null");
        this.path.clear();
        this.addPath(elements);
        return this;
    }

    public UrlStringBuilder addPath(String element) {
        Validate.notNull((Object)element, (String)"element cannot be null");
        this.path.add(element);
        return this;
    }

    public UrlStringBuilder addPath(String ... elements) {
        Validate.noNullElements((Object[])elements, (String)"elements cannot be null");
        for (String element : elements) {
            this.path.add(element);
        }
        return this;
    }

    public Object clone() {
        return new UrlStringBuilder(this);
    }

    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder url = new StringBuilder();
        if (this.host != null) {
            url.append(this.protocol).append("://").append(this.host);
            if (this.port != null) {
                url.append(":").append(this.port);
            }
        }
        if (this.context != null) {
            url.append("/").append(this.context);
        } else if (this.path.size() == 0) {
            url.append("/");
        }
        for (String element : this.path) {
            url.append("/").append(this.encode(element));
        }
        if (this.parameters.size() > 0) {
            url.append("?");
            Iterator paramEntryItr = this.parameters.entrySet().iterator();
            while (paramEntryItr.hasNext()) {
                Map.Entry paramEntry = paramEntryItr.next();
                String name = (String)paramEntry.getKey();
                List values = (List)paramEntry.getValue();
                name = this.encode(name);
                if (values == null || values.size() == 0) {
                    url.append(name);
                } else {
                    Iterator valueItr = values.iterator();
                    while (valueItr.hasNext()) {
                        String value = (String)valueItr.next();
                        if (value == null) {
                            value = "";
                        }
                        value = this.encode(value);
                        url.append(name).append("=").append(value);
                        if (!valueItr.hasNext()) continue;
                        url.append("&");
                    }
                }
                if (!paramEntryItr.hasNext()) continue;
                url.append("&");
            }
        }
        return url.toString();
    }
}

