/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url.processing;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.url.processing.IRequestParameterProcessor;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RequestParameterProcessorInterceptor
extends HandlerInterceptorAdapter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List<IRequestParameterProcessor> dynamicRequestParameterProcessors = Collections.emptyList();
    private int maxNumberOfProcessingCycles = 10;

    public List<IRequestParameterProcessor> getDynamicRequestParameterProcessors() {
        return this.dynamicRequestParameterProcessors;
    }

    public void setDynamicRequestParameterProcessors(List<IRequestParameterProcessor> dynamicRequestParameterProcessors) {
        Validate.notNull(dynamicRequestParameterProcessors, (String)"IRequestParameterProcessor List can not be null");
        Validate.noNullElements(dynamicRequestParameterProcessors, (String)"IRequestParameterProcessor List can not contain a null element");
        this.dynamicRequestParameterProcessors = dynamicRequestParameterProcessors;
    }

    public int getMaxNumberOfProcessingCycles() {
        return this.maxNumberOfProcessingCycles;
    }

    public void setMaxNumberOfProcessingCycles(int maxNumberOfProcessingCycles) {
        this.maxNumberOfProcessingCycles = maxNumberOfProcessingCycles;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        LinkedList incompleteDynamicProcessors = new LinkedList(this.dynamicRequestParameterProcessors);
        int cycles = 0;
        while (incompleteDynamicProcessors.size() > 0) {
            Iterator processorItr = incompleteDynamicProcessors.iterator();
            while (processorItr.hasNext()) {
                IRequestParameterProcessor requestParameterProcessor = (IRequestParameterProcessor)processorItr.next();
                boolean complete = requestParameterProcessor.processParameters(request, response);
                if (!complete) continue;
                processorItr.remove();
            }
            if (++cycles < this.maxNumberOfProcessingCycles) continue;
            this.logger.warn((Object)(incompleteDynamicProcessors.size() + " IDynamicRequestParameterProcessors did not complete processing after " + cycles + " attempts. Execution will continue but this situation should be reviewed. Incomplete Processors=" + incompleteDynamicProcessors), new Throwable("Stack Trace"));
            break;
        }
        return true;
    }
}

