/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.user;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.PortalException;
import org.jasig.portal.UserInstance;
import org.jasig.portal.UserPreferencesManager;
import org.jasig.portal.i18n.ILocaleStore;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.IProfileMapper;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutManagerFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.user.UserInstanceManagerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userInstanceManager")
public class UserInstanceManagerImpl
implements IUserInstanceManager {
    private static final String KEY = UserInstanceManagerImpl.class.getName() + ".USER_INSTANCE";
    protected final Log logger = LogFactory.getLog(UserInstanceManagerImpl.class);
    private ILocaleStore localeStore;
    private IUserLayoutStore userLayoutStore;
    private IPersonManager personManager;
    private IPortalRequestUtils portalRequestUtils;
    private IProfileMapper profileMapper;
    private UserLayoutManagerFactory userLayoutManagerFactory;

    @Autowired
    public void setUserLayoutManagerFactory(UserLayoutManagerFactory userLayoutManagerFactory) {
        this.userLayoutManagerFactory = userLayoutManagerFactory;
    }

    @Autowired
    public void setLocaleStore(ILocaleStore localeStore) {
        this.localeStore = localeStore;
    }

    @Autowired
    public void setUserLayoutStore(IUserLayoutStore userLayoutStore) {
        this.userLayoutStore = userLayoutStore;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired
    public void setProfileMapper(IProfileMapper profileMapper) {
        this.profileMapper = profileMapper;
    }

    public IUserInstance getUserInstance(HttpServletRequest request) throws PortalException {
        IPerson person;
        try {
            request = this.portalRequestUtils.getOriginalPortalRequest(request);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        IUserInstance userInstance = (IUserInstance)request.getAttribute(KEY);
        if (userInstance != null) {
            return userInstance;
        }
        try {
            person = this.personManager.getPerson(request);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception while retrieving IPerson!", (Throwable)e);
            throw new PortalSecurityException("Could not retrieve IPerson", (Throwable)e);
        }
        if (person == null) {
            throw new PortalSecurityException("PersonManager returned null person for this request.  With no user, there's no UserInstance.  Is PersonManager misconfigured?  RDBMS access misconfigured?");
        }
        HttpSession session = request.getSession();
        if (session == null) {
            throw new IllegalStateException("HttpServletRequest.getSession() returned a null session for request: " + request);
        }
        UserInstanceHolder userInstanceHolder = this.getUserInstanceHolder(session);
        if (userInstanceHolder != null && (userInstance = userInstanceHolder.getUserInstance()) != null) {
            return userInstance;
        }
        LocaleManager localeManager = this.getLocaleManager(request, person);
        String userAgent = this.getUserAgent(request);
        IUserProfile userProfile = this.getUserProfile(request, person, localeManager, userAgent);
        IUserLayoutManager userLayoutManager = this.userLayoutManagerFactory.getUserLayoutManager(person, userProfile);
        if (person.isGuest()) {
            userLayoutManager = this.userLayoutManagerFactory.immutableUserLayoutManager(userLayoutManager);
        }
        UserPreferencesManager userPreferencesManager = new UserPreferencesManager(person, userProfile, userLayoutManager);
        userInstance = new UserInstance(person, (IUserPreferencesManager)userPreferencesManager, localeManager);
        if (userInstanceHolder == null) {
            userInstanceHolder = new UserInstanceHolder(null);
        }
        userInstanceHolder.setUserInstance(userInstance);
        session.setAttribute(KEY, (Object)userInstanceHolder);
        request.setAttribute(KEY, (Object)userInstance);
        return userInstance;
    }

    protected IUserProfile getUserProfile(HttpServletRequest request, IPerson person, LocaleManager localeManager, String userAgent) {
        String profileFname = this.profileMapper.getProfileFname(person, request);
        IUserProfile userProfile = this.userLayoutStore.getUserProfileByFname(person, profileFname);
        if (userProfile == null) {
            userProfile = this.userLayoutStore.getSystemProfileByFname(profileFname);
        }
        if (localeManager != null && LocaleManager.isLocaleAware()) {
            userProfile.setLocaleManager(localeManager);
        }
        return userProfile;
    }

    protected LocaleManager getLocaleManager(HttpServletRequest request, IPerson person) {
        String acceptLanguage = request.getHeader("Accept-Language");
        Locale[] userLocales = this.localeStore.getUserLocales(person);
        return new LocaleManager(person, userLocales, acceptLanguage);
    }

    protected String getUserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isEmpty((String)userAgent)) {
            userAgent = "null";
        }
        return userAgent;
    }

    protected UserInstanceHolder getUserInstanceHolder(HttpSession session) {
        return (UserInstanceHolder)session.getAttribute(KEY);
    }
}

