/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import com.google.common.base.Function;
import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jasig.portal.utils.DirectoryScanner;
import org.jasig.portal.utils.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public final class ConcurrentDirectoryScanner
implements DirectoryScanner {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService executorService;
    private boolean processDirectories = false;
    private boolean recursive = true;
    private long maxWait = -1L;
    private TimeUnit maxWaitTimeUnit = TimeUnit.MILLISECONDS;

    public ConcurrentDirectoryScanner(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setProcessDirectories(boolean processDirectories) {
        this.processDirectories = processDirectories;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public void setMaxWaitTimeUnit(TimeUnit maxWaitTimeUnit) {
        this.maxWaitTimeUnit = maxWaitTimeUnit;
    }

    public <T> Map<File, T> scanDirectoryWithResults(File directory, FileFilter fileFilter, Function<Resource, T> fileProcessor) {
        ConcurrentHashMap results = new ConcurrentHashMap();
        this.scanDirectory(directory, results, fileFilter, fileProcessor);
        return results;
    }

    public void scanDirectoryNoResults(File directory, FileFilter fileFilter, Function<Resource, ?> fileProcessor) {
        this.scanDirectory(directory, null, fileFilter, fileProcessor);
    }

    protected <T> void scanDirectory(File directory, ConcurrentMap<File, T> results, FileFilter fileFilter, Function<Resource, T> fileProcessor) {
        ConcurrentLinkedQueue futures = new ConcurrentLinkedQueue();
        this.recurseOnDirectory(futures, results, directory, fileFilter, fileProcessor);
        this.waitForFutures(futures, results);
    }

    protected <T> void recurseOnDirectory(Queue<Tuple<File, Future<T>>> futures, ConcurrentMap<File, T> results, File directory, FileFilter fileFilter, Function<Resource, T> fileProcessor) {
        File[] children;
        this.logger.debug("processing directory: {}", (Object)directory);
        for (File child : children = directory.listFiles(fileFilter)) {
            if (child.isDirectory()) {
                if (!this.recursive) continue;
                if (this.processDirectories) {
                    this.submitProcessFile(futures, child, fileProcessor);
                }
                this.submitDirectoryRecurse(futures, results, child, fileFilter, fileProcessor);
                continue;
            }
            this.submitProcessFile(futures, child, fileProcessor);
        }
        this.cleanFutures(futures, results);
    }

    protected <T> void submitDirectoryRecurse(Queue<Tuple<File, Future<T>>> futures, ConcurrentMap<File, T> results, File directory, FileFilter fileFilter, Function<Resource, T> fileProcessor) {
        Future dirFuture = this.executorService.submit(new /* Unavailable Anonymous Inner Class!! */);
        this.logger.debug("queued directory recurse: {}", (Object)directory);
        futures.offer(new Tuple((Object)directory, dirFuture));
    }

    protected <T> void submitProcessFile(Queue<Tuple<File, Future<T>>> futures, File child, Function<Resource, T> fileProcessor) {
        Future fileFuture = this.executorService.submit(new /* Unavailable Anonymous Inner Class!! */);
        this.logger.debug("queued file processing: {}", (Object)child);
        futures.offer(new Tuple((Object)child, fileFuture));
    }

    protected <T> void cleanFutures(Queue<Tuple<File, Future<T>>> futures, ConcurrentMap<File, T> results) {
        Iterator futureItr = futures.iterator();
        while (futureItr.hasNext()) {
            Tuple future = (Tuple)futureItr.next();
            if (!((Future)future.second).isDone()) continue;
            futureItr.remove();
            try {
                this.processResult(results, future);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return;
            }
        }
    }

    protected <T> void waitForFutures(Queue<Tuple<File, Future<T>>> futures, ConcurrentMap<File, T> results) {
        while (!futures.isEmpty()) {
            Tuple<File, Future<T>> future = futures.poll();
            try {
                this.processResult(results, future);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return;
            }
        }
    }

    protected <T> void processResult(ConcurrentMap<File, T> results, Tuple<File, Future<T>> future) throws InterruptedException {
        Object result;
        try {
            result = this.maxWait < 0L ? ((Future)future.second).get() : ((Future)future.second).get(this.maxWait, this.maxWaitTimeUnit);
            this.logger.debug("processing complete: {}", future.first);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception processing for file: " + future.first, e.getCause());
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timeout waiting for file: " + future.first, e);
        }
        if (results != null && result != null) {
            results.put((File)future.first, result);
        }
    }
}

