/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;

public class PatternSetFileFilter
implements FileFilter {
    private final boolean acceptDirectories;
    private final boolean ignoreHidden;
    private final Collection<Pattern> patterns;

    public PatternSetFileFilter(boolean acceptDirectories, boolean ignoreHidden, Pattern pattern) {
        Validate.notNull((Object)pattern);
        this.patterns = Arrays.asList(pattern);
        this.acceptDirectories = acceptDirectories;
        this.ignoreHidden = ignoreHidden;
    }

    public PatternSetFileFilter(boolean acceptDirectories, boolean ignoreHidden, Set<Pattern> patterns) {
        Validate.notNull(patterns);
        this.patterns = new HashSet<Pattern>(patterns);
        this.acceptDirectories = acceptDirectories;
        this.ignoreHidden = ignoreHidden;
    }

    @Override
    public boolean accept(File pathname) {
        if (this.acceptDirectories && pathname.isDirectory()) {
            return true;
        }
        if (this.ignoreHidden && pathname.isHidden()) {
            return false;
        }
        String name = pathname.getName();
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }
}

