/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.security.SecureRandom;
import java.util.Random;

public final class RandomTokenGenerator {
    private static final char[] DEFAULT_TOKEN_CHARS = new char[]{'2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final RandomTokenGenerator INSTANCE = new RandomTokenGenerator((Random)new SecureRandom());
    private final Random random;
    private final char[] tokenChars;
    private final double bitsPerChar;

    public RandomTokenGenerator(Random random) {
        this(random, DEFAULT_TOKEN_CHARS);
    }

    public RandomTokenGenerator(Random random, char[] tokenChars) {
        this.random = random;
        this.tokenChars = (char[])tokenChars.clone();
        this.bitsPerChar = Math.log(tokenChars.length) / Math.log(2.0);
    }

    public RandomTokenGenerator(char[] tokenChars) {
        this((Random)new SecureRandom(), tokenChars);
    }

    public String generateRandomToken(int length) {
        char[] token = new char[length];
        for (int i = 0; i < length; ++i) {
            int tokenIndex = this.random.nextInt(this.tokenChars.length);
            token[i] = this.tokenChars[tokenIndex];
        }
        return new String(token);
    }

    public int getLengthRequiredForBits(int bits) {
        double length = (double)bits / this.bitsPerChar;
        return (int)Math.ceil(length);
    }

    public double getNumberOfRandomBits(int length) {
        double bitsPerToken = this.bitsPerChar * (double)length;
        return bitsPerToken;
    }
}

