/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.util.HashMap;
import org.jasig.portal.utils.SmartCache;

public class SmartCache
extends HashMap {
    protected int iExpirationTimeout = 3600000;

    public SmartCache(int iExpirationTimeout) {
        this.iExpirationTimeout = iExpirationTimeout * 1000;
    }

    public SmartCache() {
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        ValueWrapper valueWrapper = new ValueWrapper(this, value);
        return super.put(key, valueWrapper);
    }

    public synchronized Object put(Object key, Object value, long lCacheInterval) {
        ValueWrapper valueWrapper = new ValueWrapper(this, value, lCacheInterval);
        return super.put(key, valueWrapper);
    }

    @Override
    public synchronized Object get(Object key) {
        ValueWrapper valueWrapper = (ValueWrapper)super.get(key);
        if (valueWrapper != null) {
            long creationTime = valueWrapper.getCreationTime();
            long cacheInterval = valueWrapper.getCacheInterval();
            long currentTime = System.currentTimeMillis();
            if (cacheInterval >= 0L && creationTime + cacheInterval < currentTime) {
                this.remove(key);
                return null;
            }
            return valueWrapper.getValue();
        }
        return null;
    }

    protected void sweepCache() {
        for (Object key : this.keySet()) {
            ValueWrapper valueWrapper = (ValueWrapper)super.get(key);
            long creationTime = valueWrapper.getCreationTime();
            long cacheInterval = valueWrapper.getCacheInterval();
            long currentTime = System.currentTimeMillis();
            if (cacheInterval < 0L || creationTime + cacheInterval >= currentTime) continue;
            this.remove(key);
        }
    }
}

