/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.Serializable;

public class Tuple<A, B>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final A first;
    public final B second;
    private final boolean immutable;
    private final int hash;

    public static <A1, B1> Tuple<A1, B1> of(A1 a1, B1 b1) {
        return new Tuple(a1, b1);
    }

    public Tuple(A first, B second) {
        this(first, second, false);
    }

    public Tuple(A first, B second, boolean immutable) {
        this.first = first;
        this.second = second;
        this.immutable = immutable;
        this.hash = this.immutable ? this.internalHashCode() : 0;
    }

    public A getFirst() {
        return (A)this.first;
    }

    public B getSecond() {
        return (B)this.second;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }

    public int hashCode() {
        if (this.immutable) {
            return this.hash;
        }
        return this.internalHashCode();
    }

    private int internalHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public String toString() {
        return "Tuple [first=" + this.first + ", second=" + this.second + "]";
    }
}

