/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache.resource;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.jasig.portal.utils.cache.resource.CachedResource;
import org.jasig.portal.utils.cache.resource.CachedResourceImpl;
import org.jasig.portal.utils.cache.resource.CachingResourceLoader;
import org.jasig.portal.utils.cache.resource.CachingResourceLoaderImpl;
import org.jasig.portal.utils.cache.resource.LoadedResource;
import org.jasig.portal.utils.cache.resource.Loader;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class CachingResourceLoaderImpl
implements CachingResourceLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CachedResourceEntryFactory entryFactory = new CachedResourceEntryFactory(this, null);
    private long checkInterval = TimeUnit.MINUTES.toMillis(1L);
    private Ehcache resourceCache;
    private ResourcesElementsProvider resourcesElementsProvider;

    @Autowired
    public void setResourceCache(@Qualifier(value="org.jasig.portal.utils.cache.resource.CachingResourceLoader") Ehcache resourceCache) {
        this.resourceCache = new SelfPopulatingCache(resourceCache, (CacheEntryFactory)this.entryFactory);
    }

    @Autowired
    public void setResourcesElementsProvider(ResourcesElementsProvider resourcesElementsProvider) {
        this.resourcesElementsProvider = resourcesElementsProvider;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public <T> CachedResource<T> getResource(Resource resource, Loader<T> builder) throws IOException {
        return this.getResource(resource, builder, this.checkInterval);
    }

    public <T> CachedResource<T> getResource(Resource resource, Loader<T> builder, long checkInterval) throws IOException {
        boolean resourceModified;
        long lastCheckTime;
        if (Included.PLAIN == this.resourcesElementsProvider.getDefaultIncludedType()) {
            this.logger.trace("Resoure Aggregation Disabled, ignoring resource cache and loading '" + resource + "' directly");
            return this.loadResource(resource, builder);
        }
        GetResourceArguments arguments = new GetResourceArguments(resource, builder);
        Element element = this.entryFactory.getWithData(this.resourceCache, (Object)resource, (Object)arguments);
        CachedResource cachedResource = (CachedResource)element.getObjectValue();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Found " + cachedResource + " in cache");
        }
        if ((lastCheckTime = cachedResource.getLastCheckTime()) + checkInterval >= System.currentTimeMillis()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(cachedResource + " is within checkInterval " + checkInterval + ", returning");
            }
            return cachedResource;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(cachedResource + " is older than checkInterval " + checkInterval + ", checking for modification");
        }
        if (!(resourceModified = this.checkIfModified(cachedResource))) {
            cachedResource.setLastCheckTime(System.currentTimeMillis());
            this.resourceCache.put(element);
            return cachedResource;
        }
        cachedResource = this.loadResource(resource, builder);
        this.resourceCache.put(new Element((Object)resource, (Object)cachedResource));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loaded and cached " + cachedResource);
        }
        return cachedResource;
    }

    protected <T> boolean checkIfModified(CachedResource<T> cachedResource) {
        long mainLastModified;
        boolean resourceModified;
        Resource resource = cachedResource.getResource();
        long lastLoadTime = cachedResource.getLastLoadTime();
        boolean bl = resourceModified = lastLoadTime < (mainLastModified = this.getLastModified(resource));
        if (resourceModified) {
            this.logger.trace("Resource {} was modified at {}, reloading", new Object[]{resource, mainLastModified});
            return true;
        }
        for (Map.Entry additionalResourceEntry : cachedResource.getAdditionalResources().entrySet()) {
            Resource additionalResource = (Resource)additionalResourceEntry.getKey();
            Long resourceLastLoadTime = (Long)additionalResourceEntry.getValue();
            long lastModified = this.getLastModified(additionalResource);
            if (resourceLastLoadTime >= lastModified) continue;
            this.logger.trace("Additional resource {} for {} was modified at {}, reloading", new Object[]{additionalResource, resource, lastModified});
            return true;
        }
        this.logger.trace("{} has not been modified since last loaded {}, returning", cachedResource, (Object)lastLoadTime);
        return false;
    }

    protected long getLastModified(Resource resource) {
        try {
            return resource.lastModified();
        }
        catch (IOException e) {
            this.logger.warn("Could not determine lastModified for " + resource + ". This resource will never be reloaded due to lastModified changing.", (Throwable)e);
            return 0L;
        }
    }

    private <T> CachedResource<T> loadResource(Resource resource, Loader<T> builder) throws IOException {
        long lastLoadTime = System.currentTimeMillis();
        long lastModified = 0L;
        try {
            lastModified = resource.lastModified();
        }
        catch (IOException e) {
            // empty catch block
        }
        LoadedResource loadedResource = builder.loadResource(resource);
        Serializable cacheKey = (Serializable)((Object)Arrays.asList(lastModified, loadedResource.getAdditionalResources()));
        return new CachedResourceImpl(resource, loadedResource, lastLoadTime, cacheKey);
    }

    static /* synthetic */ CachedResource access$100(CachingResourceLoaderImpl x0, Resource x1, Loader x2) throws IOException {
        return x0.loadResource(x1, x2);
    }
}

