/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jasig.portal.utils.cache.resource.LoadedResource;
import org.springframework.core.io.Resource;

public class LoadedResourceImpl<T>
implements LoadedResource<T> {
    private final T resource;
    private final Map<Resource, Long> additionalSources;

    public LoadedResourceImpl(T resource) {
        this(resource, null);
    }

    public LoadedResourceImpl(T resource, Map<Resource, Long> additionalSources) {
        this.resource = resource;
        this.additionalSources = additionalSources == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<Resource, Long>(additionalSources));
    }

    public T getLoadedResource() {
        return (T)this.resource;
    }

    public Map<Resource, Long> getAdditionalResources() {
        return this.additionalSources;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalSources == null ? 0 : this.additionalSources.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadedResourceImpl other = (LoadedResourceImpl)obj;
        if (this.additionalSources == null ? other.additionalSources != null : !this.additionalSources.equals(other.additionalSources)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }

    public String toString() {
        return "LoadedResourceImpl [resource=" + this.resource + ", additionalSources=" + this.additionalSources + "]";
    }
}

