/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.jsp;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jasig.portal.spring.beans.factory.ObjectMapperFactoryBean;

public class Util {
    private static final ObjectMapper OBJECT_MAPPER;

    public static boolean contains(Collection<?> coll, Object o) {
        return coll != null && coll.contains(o);
    }

    public static boolean containsKey(Map<?, ?> map, Object o) {
        return map != null && map.containsKey(o);
    }

    public static boolean containsValue(Map<?, ?> map, Object o) {
        return map != null && map.containsValue(o);
    }

    public static boolean instanceOf(Object obj, String className) throws ClassNotFoundException {
        ClassLoader cl = obj.getClass().getClassLoader();
        Class<?> clazz = Class.forName(className, true, cl);
        boolean isInstanceOf = obj.getClass().isAssignableFrom(clazz);
        return isInstanceOf;
    }

    public static String json(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    static {
        ObjectMapper mapper;
        try {
            ObjectMapperFactoryBean omfb = new ObjectMapperFactoryBean();
            omfb.afterPropertiesSet();
            mapper = (ObjectMapper)omfb.getObject();
        }
        catch (Exception e) {
            mapper = new ObjectMapper();
            mapper.findAndRegisterModules();
        }
        OBJECT_MAPPER = mapper;
    }
}

