/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.threading;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DoubleCheckedCreator<T> {
    private static String LOGGER_NAME = DoubleCheckedCreator.class.getName();
    private Log logger;
    private final ReadWriteLock readWriteLock;
    protected final Lock readLock;
    protected final Lock writeLock;

    protected Log getLogger() {
        Log l = this.logger;
        if (l == null) {
            this.logger = l = LogFactory.getLog((String)LOGGER_NAME);
        }
        return l;
    }

    public DoubleCheckedCreator() {
        this((ReadWriteLock)new ReentrantReadWriteLock());
    }

    public DoubleCheckedCreator(ReadWriteLock readWriteLock) {
        Validate.notNull((Object)readWriteLock, (String)"readWriteLock can not be null");
        this.readWriteLock = readWriteLock;
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
    }

    protected abstract T create(Object ... var1);

    protected abstract T retrieve(Object ... var1);

    protected boolean invalid(T value, Object ... args) {
        return value == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get(Object ... args) {
        Object value;
        this.readLock.lock();
        try {
            value = this.retrieve(args);
            if (!this.invalid(value, args)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Using retrieved Object='" + value + "'"));
                }
                Object object = value;
                return (T)object;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            value = this.retrieve(args);
            if (this.invalid(value, args)) {
                value = this.create(args);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Created new Object='" + value + "'"));
                }
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Using retrieved Object='" + value + "'"));
            }
            Object object = value;
            return (T)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

